/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.emailplugin;

import com.prosc.io.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import javax.mail.MessagingException;
import javax.mail.internet.MimePart;

public final class AttachmentInfo {
    private final MimePart part;
    private final File file;
    private final String fmPath;

    public AttachmentInfo(MimePart part, File f, String fmPath) {
        this.part = part;
        this.file = f;
        this.fmPath = fmPath;
    }

    public MimePart getPart() {
        return this.part;
    }

    public File getFile() {
        return this.file;
    }

    public String getFmPath() {
        return this.fmPath;
    }

    public String toString() {
        return "AttachmentInfo{part=" + this.part + ", file=" + this.file + '}';
    }

    public String getAttachentDataUrl() throws IOException, MessagingException {
        String contentType = this.part.getContentType();
        if (contentType.indexOf(59) != -1) {
            contentType = contentType.substring(0, contentType.indexOf(59));
        }
        String base64str = Base64.getEncoder().encodeToString(IOUtils.fileAsBytes(this.file));
        return ("data:" + contentType + ";base64,").concat(base64str);
    }
}

