/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.emailplugin;

import com.prosc.aws.Region;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.SESException;
import com.prosc.aws.ses.EmailResult;
import com.prosc.aws.ses.RawEmailSender;
import com.prosc.core.FeedbackException;
import com.prosc.emailplugin.EmailerModel;
import com.prosc.emailplugin.PluginMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

class AmazonOutbound
extends EmailerModel {
    private final String accessKey;
    private final String secretKey;
    private Region region;

    public AmazonOutbound(String accessKey, String secretKey) throws FeedbackException, MessagingException {
        this(accessKey, secretKey, null);
    }

    public AmazonOutbound(String accessKey, String secretKey, Region region) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.region = region;
    }

    @Override
    public void send() throws MessagingException, IOException, SESException {
        EmailResult emailResult;
        Address[] bccArray;
        Address[] ccArray;
        RawEmailSender sender = new RawEmailSender(new Signer(this.accessKey, this.secretKey, this.region));
        PluginMessage.MyMimeMessage mimeMessage = this.getPluginMessage().getMimeMessage();
        Address[] toArray = mimeMessage.getRecipients(MimeMessage.RecipientType.TO);
        if (toArray != null) {
            for (Address recipient : toArray) {
                sender.addRecipientTo(recipient.toString());
            }
        }
        if ((ccArray = mimeMessage.getRecipients(MimeMessage.RecipientType.CC)) != null) {
            for (Address recipient : ccArray) {
                sender.addCcTo(recipient.toString());
            }
        }
        if ((bccArray = mimeMessage.getRecipients(MimeMessage.RecipientType.BCC)) != null) {
            for (Address recipient : bccArray) {
                sender.addBccTo(recipient.toString());
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Object object = null;
        try {
            this.getPluginMessage().buildMimeMessage().writeTo(baos);
            sender.setRawMessage(baos.toByteArray());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (baos != null) {
                if (object != null) {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    baos.close();
                }
            }
        }
        try {
            emailResult = sender.call();
        }
        catch (SESException e) {
            throw new MessagingException(e.getMessage());
        }
        this.lastSentMessageId = emailResult.getMessageId();
    }

    @Override
    public synchronized void disconnect() throws MessagingException {
        try {
            this.closeLastAccessedFolder();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Could not close last accessed folder " + this.lastAccessedFolder, e);
        }
        this.lastAccessedFolder = null;
        this.closeQuietly(this.smtpTransport);
        this.smtpTransport = null;
        this.closeQuietly(this.inboundStore);
        this.inboundStore = null;
        this.activeSmtpConnect = null;
        this.activeInboundConnect = null;
        this.session = null;
        this.setCurrentMessage((PluginMessage)null);
    }
}

