/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.data;

import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ChunkedSpliterator<T>
implements Spliterator<T> {
    private final Function<Object, Chunk<T>> fetchFunction;
    private Iterator<T> nextItem;
    private int size;
    private Object nextToken;

    public ChunkedSpliterator(Function<Object, Chunk<T>> fetchFunction) {
        this(fetchFunction, null);
    }

    private ChunkedSpliterator(Function<Object, Chunk<T>> fetchFunction, Object startingToken) {
        this.fetchFunction = fetchFunction;
        this.readChunk(startingToken);
    }

    private void readChunk(Object startingToken) {
        Chunk<T> chunk = this.fetchFunction.apply(startingToken);
        this.nextToken = chunk.nextToken;
        this.nextItem = chunk.items.iterator();
        this.size = chunk.items.size();
    }

    @Override
    public int characteristics() {
        int result = 273;
        if (this.nextToken == null) {
            result |= 0x40;
        }
        return result;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this.nextItem.hasNext()) {
            action.accept(this.nextItem.next());
            return true;
        }
        if (this.nextToken == null) {
            return false;
        }
        this.readChunk(this.nextToken);
        return this.tryAdvance(action);
    }

    @Override
    public Spliterator<T> trySplit() {
        if (this.nextToken == null) {
            return null;
        }
        ChunkedSpliterator<T> result = new ChunkedSpliterator<T>(this.fetchFunction, this.nextToken);
        this.nextToken = null;
        return result;
    }

    @Override
    public long estimateSize() {
        return this.nextToken == null ? (long)this.size : Long.MAX_VALUE;
    }

    public static class Chunk<T> {
        List<T> items;
        Object nextToken;

        public Chunk(List<T> items, Object nextToken) {
            this.items = items;
            this.nextToken = nextToken;
        }
    }
}

