/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.sns;

import com.prosc.aws.AwsRequest;
import com.prosc.aws.AwsResult;
import com.prosc.aws.ResponseStyle;
import com.prosc.aws.Signer;
import com.prosc.io.IOUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public abstract class SnsRequest<T>
extends AwsRequest<T> {
    private final boolean encrypt;

    public SnsRequest(Signer signer, boolean encrypt) {
        super(signer);
        this.setQueryParam("Version", "2010-03-31");
        this.encrypt = encrypt;
    }

    @Override
    protected AwsResult _send(String nextToken) throws IOException {
        URL endpoint = new URL(this.encrypt ? "https" : "http", "sns." + this.getRegion().code + ".amazonaws.com", "");
        HttpURLConnection connection = (HttpURLConnection)endpoint.openConnection();
        connection.setConnectTimeout(20000);
        connection.setUseCaches(false);
        connection.setRequestMethod("POST");
        String postParam = IOUtils.urlEncodeMap(this.getAllParams());
        if (this.getSigner() != null) {
            this.getSigner().signRequestV4(connection, this.getRegion(), "sns", this, postParam.getBytes(StandardCharsets.UTF_8));
        }
        IOUtils.postDataToUrlConnection(postParam, connection);
        return new AwsResult(connection, ResponseStyle.xml, this).download();
    }
}

