/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.sns;

import com.prosc.aws.AwsLogHandler;
import com.prosc.aws.Signer;
import com.prosc.aws.sns.Publish;
import java.io.IOException;
import java.util.logging.LogManager;
import java.util.logging.SimpleFormatter;
import org.jetbrains.annotations.NotNull;

public class SNSLogHandler
extends AwsLogHandler {
    private static final int MAX_LENGTH = 262144;
    private static final String TOPIC_KEY;
    private static final String ACCESS_KEY;
    private static final String SECRET_KEY;
    private final String topicArn;
    private final Signer signer;

    public SNSLogHandler() {
        super(true);
        LogManager manager = LogManager.getLogManager();
        this.setFormatter(new SimpleFormatter());
        this.topicArn = manager.getProperty(TOPIC_KEY);
        if (this.topicArn == null) {
            throw new IllegalArgumentException("You must set the " + TOPIC_KEY + " property in the log configuration file.");
        }
        String accessKey = manager.getProperty(ACCESS_KEY);
        String secretKey = manager.getProperty(SECRET_KEY);
        Signer _signer = null;
        if (accessKey == null && secretKey == null) {
            _signer = Signer.getSignerForRole();
        }
        if (_signer == null) {
            if (accessKey == null) {
                throw new IllegalArgumentException("You must set the " + ACCESS_KEY + " property in the log configuration file.");
            }
            if (secretKey == null) {
                throw new IllegalArgumentException("You must set the " + SECRET_KEY + " property in the log configuration file.");
            }
            _signer = new Signer(accessKey, secretKey);
        }
        this.signer = _signer;
        this.setFormatter(new SimpleFormatter());
    }

    public SNSLogHandler(String topicArn, boolean autoflush) {
        this(Signer.getSignerForRole(), topicArn, autoflush);
    }

    public SNSLogHandler(@NotNull Signer signer, String topicArn, boolean autoflush) {
        if (signer == null) {
            SNSLogHandler.$$$reportNull$$$0(0);
        }
        this(signer, topicArn, autoflush, true);
    }

    public SNSLogHandler(@NotNull Signer signer, String topicArn, boolean autoflush, boolean asynchronous) {
        if (signer == null) {
            SNSLogHandler.$$$reportNull$$$0(1);
        }
        super(autoflush, asynchronous);
        this.signer = signer;
        this.topicArn = topicArn;
    }

    @Override
    protected void publish(StringBuilder sb) throws IOException {
        String message = sb.toString();
        if (message.length() > 262144) {
            message = message.substring(0, 262143);
        }
        new Publish(this.signer, true, message, false, this.topicArn).setSubject(this.getSubject()).call();
    }

    static {
        String className = SNSLogHandler.class.getName();
        TOPIC_KEY = className + ".topicArn";
        ACCESS_KEY = className + ".accessKey";
        SECRET_KEY = className + ".secretKey";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signer", "com/prosc/aws/sns/SNSLogHandler", "<init>"));
    }
}

