/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.sns;

import com.prosc.aws.Region;
import com.prosc.aws.Signer;
import com.prosc.aws.sns.SnsRequest;
import com.prosc.shared.StringUtils;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Publish
extends SnsRequest<Publish> {
    private int messageAttributeIndex;

    public Publish(Signer signer, boolean encrypt, @NotNull String message, boolean json, String topicArn) {
        if (message == null) {
            Publish.$$$reportNull$$$0(0);
        }
        super(signer, encrypt);
        this.messageAttributeIndex = 1;
        this.setQueryParam("Action", "Publish");
        this.setPostParam("Message", message);
        if (json) {
            this.setQueryParam("MessageStructure", "json");
        }
        this.setQueryParam("TopicArn", topicArn);
        String[] arnSections = topicArn.split(":", -1);
        this.setRegion(Region.getRegionByCode(arnSections[3]));
    }

    public Publish setSubject(String subject) {
        this.setQueryParam("Subject", StringUtils.truncate(subject, 99));
        return this;
    }

    public Publish setMessageAttribute(String name, @Nullable String value, @Nullable String type) {
        this.setPostParam(String.format("MessageAttributes.entry.%d.Name", this.messageAttributeIndex), name);
        if (value != null) {
            this.setPostParam(String.format("MessageAttributes.entry.%d.Value.StringValue", this.messageAttributeIndex), value);
        }
        if (type != null) {
            this.setPostParam(String.format("MessageAttributes.entry.%d.Value.DataType", this.messageAttributeIndex), type);
        }
        ++this.messageAttributeIndex;
        return this;
    }

    public Publish setOriginationNumber(String originationNumber) {
        this.setMessageAttribute("AWS.MM.SMS.OriginationNumber", originationNumber, "String");
        return this;
    }

    public Publish setSenderId(String senderId) {
        this.setMessageAttribute("AWS.SNS.SMS.SenderID", senderId, "String");
        return this;
    }

    public void call() throws IOException {
        this.sendWithRetry().validate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/prosc/aws/sns/Publish", "<init>"));
    }
}

