/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.sns;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.prosc.aws.exception.AWSRuntimeException;
import com.prosc.io.IOUtils;
import com.prosc.shared.StringUtils;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.security.cert.X509Certificate;

public class MessageParser {
    private static final Map<URL, PublicKey> awsPublicKey = new HashMap<URL, PublicKey>(1);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static Map<String, String> parseJson(String json) throws Exception {
        Map result = objectMapper.readValue(json, Map.class);
        MessageParser.validateSignature(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateSignature(Map<String, String> result) throws Exception {
        String[] keys;
        String messageType;
        URL signingCertURL = IOUtils.toUrl(result.get("SigningCertURL"));
        PublicKey publicKey = awsPublicKey.get(signingCertURL);
        if (publicKey == null) {
            if (!"https".equals(signingCertURL.getProtocol()) || !signingCertURL.getHost().endsWith("amazonaws.com")) {
                throw new AWSRuntimeException("Untrusted certificate download URL: " + signingCertURL + ". Message contents: " + result);
            }
            try (InputStream certStream = signingCertURL.openStream();){
                X509Certificate certificate = X509Certificate.getInstance(certStream);
                publicKey = certificate.getPublicKey();
                awsPublicKey.put(signingCertURL, publicKey);
            }
        }
        if ("SubscriptionConfirmation".equals(messageType = result.get("Type"))) {
            keys = new String[]{"Message", "MessageId", "SubscribeURL", "Timestamp", "Token", "TopicArn", "Type"};
        } else if ("Notification".equals(messageType)) {
            keys = new String[]{"Message", "MessageId", "Subject", "Timestamp", "TopicArn", "Type"};
        } else {
            throw new IllegalArgumentException("Unknown message type: " + messageType + "; cannot validate. Message content: " + result);
        }
        if (!"1".equals(result.get("SignatureVersion"))) {
            throw new AWSRuntimeException("The SNS message is invalid; it does not have SignatureVersion '1'. Message content: " + result);
        }
        String signatureString = result.get("Signature");
        if (StringUtils.isEmpty(signatureString)) {
            throw new AWSRuntimeException("The SNS message is invalid; it does not have a signature. Message content: " + result);
        }
        byte[] signatureBytes = Base64.getDecoder().decode(signatureString);
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            String value = result.get(key);
            if (value == null) continue;
            sb.append(key).append('\n').append(value).append('\n');
        }
        Signature signature = Signature.getInstance("SHA1withRSA");
        signature.initVerify(publicKey);
        signature.update(sb.toString().getBytes(StandardCharsets.UTF_8));
        if (!signature.verify(signatureBytes)) {
            throw new AWSRuntimeException("The signature provided with this message did not match the contents of the message. The message has been tampered with or damaged. Message contents: " + result);
        }
    }
}

