/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.simpledb.gui;

import com.prosc.aws.Region;
import com.prosc.aws.Signer;
import com.prosc.aws.simpledb.ListDomains;
import com.prosc.aws.simpledb.SelectRequest;
import com.prosc.data.MultiMap;
import com.prosc.shared.ExceptionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.jetbrains.annotations.NotNull;

public class SimpleDBBrowser
extends JFrame {
    private static final Logger log = Logger.getLogger(SimpleDBBrowser.class.getName());
    private static final Preferences PREFERENCES = Preferences.userNodeForPackage(SimpleDBBrowser.class);
    private JLabel label1;
    private JTextField accessKeyField;
    private JLabel label2;
    private JPasswordField secretKeyField;
    private JLabel label3;
    private JComboBox regionComboBox;
    private JLabel label4;
    private JComboBox domainComboBox;
    private JPanel panel2;
    private JButton runButton;
    private JTextField queryField;
    private JPanel panel1;
    private JRadioButton allRecordsButton;
    private JRadioButton queryButton;
    private JScrollPane scrollPane1;
    private JTable resultTable;

    public SimpleDBBrowser() {
        this.initComponents();
    }

    private void runButtonActionPerformed() {
        try {
            String query = this.allRecordsButton.isSelected() ? "SELECT * FROM " + this.domainComboBox.getSelectedItem() : this.queryField.getText();
            Iterator<MultiMap<String, String>> rows = new SelectRequest(this.createSigner(), true, false, query).call();
            Vector dataVector = new Vector();
            if (rows.hasNext()) {
                LinkedHashSet<String> columnNames = null;
                while (rows.hasNext()) {
                    MultiMap<String, String> row = rows.next();
                    if (columnNames == null) {
                        columnNames = new LinkedHashSet<String>(row.size());
                    }
                    Vector<Object> rowVect = new Vector<Object>(columnNames.size());
                    columnNames.addAll(row.keySet());
                    for (String columnName : columnNames) {
                        rowVect.add(row.get(columnName));
                    }
                    dataVector.add(rowVect);
                }
                this.resultTable.setModel(new DefaultTableModel(dataVector, new Vector(Objects.requireNonNull(columnNames))){

                    @Override
                    public void setValueAt(Object aValue, int row, int column) {
                    }
                });
            } else {
                this.resultTable.setModel(new DefaultTableModel());
            }
        }
        catch (Exception e) {
            ExceptionUtils.reportAndLogException(Level.SEVERE, this, e.getLocalizedMessage(), e);
        }
    }

    private void allRecordsButtonActionPerformed() {
        this.queryField.setVisible(false);
        this.revalidate();
    }

    private void queryButtonActionPerformed() {
        this.queryField.setVisible(true);
        this.revalidate();
    }

    private void regionComboBoxActionPerformed() {
        new SwingWorker(){

            protected Object doInBackground() {
                try {
                    Signer signer = SimpleDBBrowser.this.createSigner();
                    Iterator<String> domainIterator = new ListDomains(signer, true).call();
                    LinkedList<String> domains = new LinkedList<String>();
                    while (domainIterator.hasNext()) {
                        domains.add(domainIterator.next());
                    }
                    EventQueue.invokeLater(() -> SimpleDBBrowser.this.domainComboBox.setModel(new DefaultComboBoxModel<Object>(domains.toArray(new Object[domains.size()]))));
                }
                catch (IOException e) {
                    EventQueue.invokeLater(() -> {
                        SimpleDBBrowser.this.domainComboBox.setModel(new DefaultComboBoxModel());
                        ExceptionUtils.reportAndLogException(Level.SEVERE, SimpleDBBrowser.this, e.getLocalizedMessage(), e);
                    });
                }
                return null;
            }
        }.execute();
    }

    @NotNull
    private Signer createSigner() {
        return new Signer(this.accessKeyField.getText(), this.secretKeyField.getText(), (Region)((Object)this.regionComboBox.getSelectedItem()));
    }

    private void accessKeyFieldFocusLost() {
        PREFERENCES.put("AWS_ACCESS_KEY", this.accessKeyField.getText());
        try {
            PREFERENCES.sync();
        }
        catch (BackingStoreException e) {
            log.log(Level.WARNING, "Could not store preferences", e);
        }
    }

    private void secretKeyFieldFocusLost() {
        PREFERENCES.put("AWS_SECRET_KEY", this.secretKeyField.getText());
        try {
            PREFERENCES.sync();
        }
        catch (BackingStoreException e) {
            log.log(Level.WARNING, "Could not store preferences", e);
        }
    }

    private void initComponents() {
        this.label1 = new JLabel();
        this.accessKeyField = new JTextField();
        this.label2 = new JLabel();
        this.secretKeyField = new JPasswordField();
        this.label3 = new JLabel();
        this.regionComboBox = new JComboBox();
        this.label4 = new JLabel();
        this.domainComboBox = new JComboBox();
        this.panel2 = new JPanel();
        this.runButton = new JButton();
        this.queryField = new JTextField();
        this.panel1 = new JPanel();
        this.allRecordsButton = new JRadioButton();
        this.queryButton = new JRadioButton();
        this.scrollPane1 = new JScrollPane();
        this.resultTable = new JTable();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        ((GridBagLayout)contentPane.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)contentPane.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)contentPane.getLayout()).columnWeights = new double[]{0.0, 1.0, 1.0E-4};
        ((GridBagLayout)contentPane.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0E-4};
        this.label1.setText("AWS Access Key");
        contentPane.add((Component)this.label1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.accessKeyField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SimpleDBBrowser.this.accessKeyFieldFocusLost();
            }
        });
        contentPane.add((Component)this.accessKeyField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.label2.setText("AWS Secret Key");
        contentPane.add((Component)this.label2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.secretKeyField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SimpleDBBrowser.this.secretKeyFieldFocusLost();
            }
        });
        contentPane.add((Component)this.secretKeyField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.label3.setText("AWS Region");
        contentPane.add((Component)this.label3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.regionComboBox.addActionListener(e -> this.regionComboBoxActionPerformed());
        contentPane.add((Component)this.regionComboBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.label4.setText("SimpleDB Domain");
        contentPane.add((Component)this.label4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        contentPane.add((Component)this.domainComboBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.panel2.setLayout(new BorderLayout());
        this.runButton.setText("Run");
        this.runButton.addActionListener(e -> this.runButtonActionPerformed());
        this.panel2.add((Component)this.runButton, "East");
        this.queryField.setVisible(false);
        this.panel2.add((Component)this.queryField, "Center");
        this.panel1.setLayout(new FlowLayout(0));
        this.allRecordsButton.setText("All records");
        this.allRecordsButton.setSelected(true);
        this.allRecordsButton.addActionListener(e -> this.allRecordsButtonActionPerformed());
        this.panel1.add(this.allRecordsButton);
        this.queryButton.setText("Query");
        this.queryButton.addActionListener(e -> this.queryButtonActionPerformed());
        this.panel1.add(this.queryButton);
        this.panel2.add((Component)this.panel1, "West");
        contentPane.add((Component)this.panel2, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.scrollPane1.setViewportView(this.resultTable);
        contentPane.add((Component)this.scrollPane1, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        ButtonGroup queryGroup = new ButtonGroup();
        queryGroup.add(this.allRecordsButton);
        queryGroup.add(this.queryButton);
        try {
            PREFERENCES.sync();
            this.accessKeyField.setText(PREFERENCES.get("AWS_ACCESS_KEY", null));
            this.secretKeyField.setText(PREFERENCES.get("AWS_SECRET_KEY", null));
        }
        catch (BackingStoreException e2) {
            log.log(Level.INFO, "Could not read from preferences", e2);
        }
        Vector<Region> regions = new Vector<Region>();
        regions.add(null);
        regions.addAll(Arrays.asList(Region.values()));
        this.regionComboBox.setModel(new DefaultComboBoxModel(regions));
        this.resultTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value != null && value instanceof Collection) {
                    int valueHeight;
                    Iterator iterator = ((Collection)value).iterator();
                    String stringValue = (String)iterator.next();
                    boolean customHeight = false;
                    if (iterator.hasNext()) {
                        stringValue = "<html>" + stringValue + "<br>" + (String)iterator.next();
                        while (iterator.hasNext()) {
                            stringValue = stringValue + "<br>" + (String)iterator.next();
                        }
                        stringValue = stringValue + "</html>";
                        customHeight = true;
                    }
                    Component result = super.getTableCellRendererComponent(table, stringValue, isSelected, hasFocus, row, column);
                    if (customHeight && (valueHeight = result.getPreferredSize().height) > table.getRowHeight(row)) {
                        table.setRowHeight(row, valueHeight);
                    }
                    return result;
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
    }

    public static void main(String[] args) {
        SimpleDBBrowser browser = new SimpleDBBrowser();
        browser.pack();
        browser.setVisible(true);
    }
}

