/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.simpledb;

import com.prosc.aws.AwsRequest;
import com.prosc.aws.AwsResult;
import com.prosc.aws.Region;
import com.prosc.aws.ResponseStyle;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.AWSRuntimeException;
import com.prosc.aws.exception.NoSuchDomainException;
import com.prosc.io.IOUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleDbRequest
extends AwsRequest<SimpleDbRequest> {
    private static final Logger log = Logger.getLogger(SimpleDbRequest.class.getName());
    private final boolean encrypt;

    public SimpleDbRequest(@NotNull Signer signer, boolean encrypt) {
        if (signer == null) {
            SimpleDbRequest.$$$reportNull$$$0(0);
        }
        super(signer);
        this.encrypt = encrypt;
        this.setQueryParam("Version", "2009-04-15");
    }

    @Override
    protected AwsResult _send(String nextToken) throws IOException {
        HttpURLConnection connection;
        URL url;
        String requestMethod;
        URL endpoint = this.getEndpoint();
        String queryString = AwsRequest.urlEncodeMap(this.getAllParams());
        boolean usePost = !this.getPostParams().isEmpty();
        String string = requestMethod = usePost ? "POST" : "GET";
        if (this.getSigner() == null) {
            throw new IllegalStateException("Signer must not be null");
        }
        if (usePost) {
            url = this.getSigner().signRequestV2WithQueryParams(endpoint, requestMethod, this.getAllParams());
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(requestMethod);
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            IOUtils.postDataToUrlConnection(queryString, connection);
        } else {
            url = new URL(endpoint, "?" + queryString);
            url = this.getSigner().signRequestV2WithQueryParams(url, requestMethod, this.getQueryParams());
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(requestMethod);
            connection.setDoOutput(false);
            connection.setUseCaches(false);
        }
        try {
            return new AwsResult(connection, ResponseStyle.xml, this).download();
        }
        catch (AWSRuntimeException e) {
            log.log(Level.WARNING, "SimpleDbRequest failed: " + this.toString());
            throw e;
        }
    }

    @NotNull
    protected URL getEndpoint() throws MalformedURLException {
        URL endpoint = this.getRegion() == Region.usEast1 ? new URL(this.encrypt ? "https" : "http", "sdb.amazonaws.com", "") : new URL(this.encrypt ? "https" : "http", "sdb." + this.getRegion().code + ".amazonaws.com", "");
        URL uRL = endpoint;
        if (uRL == null) {
            SimpleDbRequest.$$$reportNull$$$0(1);
        }
        return uRL;
    }

    protected final void validate(AwsResult awsResult) throws NoSuchDomainException {
        NoSuchDomainException.check(awsResult, this);
        awsResult.validate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/prosc/aws/simpledb/SimpleDbRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/prosc/aws/simpledb/SimpleDbRequest";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

