/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.simpledb;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.QueryTimeoutException;
import com.prosc.aws.simpledb.SimpleDbRequest;
import com.prosc.data.MultiMap;
import com.prosc.xml.DomUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectRequest
extends SimpleDbRequest {
    private String nextToken;

    public SelectRequest(Signer signer, boolean encrypt, boolean consistentRead, @NotNull String query) {
        if (query == null) {
            SelectRequest.$$$reportNull$$$0(0);
        }
        super(signer, encrypt);
        this.nextToken = null;
        this.setQueryParam("Action", "Select");
        this.setQueryParam("ConsistentRead", String.valueOf(consistentRead));
        this.setQueryParam("SelectExpression", query);
    }

    public Iterator<MultiMap<String, String>> call() throws IOException, QueryTimeoutException {
        return new Iterator<MultiMap<String, String>>(){
            private Iterator<MultiMap<String, String>> batchIterator = SelectRequest.access$000(SelectRequest.this).iterator();
            private MultiMap<String, String> nextObject = null;
            {
                this.next();
            }

            @Override
            public boolean hasNext() {
                return this.nextObject != null;
            }

            @Override
            public MultiMap<String, String> next() {
                MultiMap<String, String> result = this.nextObject;
                if (this.batchIterator.hasNext()) {
                    this.nextObject = this.batchIterator.next();
                } else if (SelectRequest.this.nextToken != null) {
                    try {
                        this.batchIterator = SelectRequest.this.getBatch().iterator();
                        this.next();
                    }
                    catch (QueryTimeoutException | IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.nextObject = null;
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private List<MultiMap<String, String>> getBatch() throws IOException, QueryTimeoutException {
        if (this.nextToken != null) {
            this.setPostParam("NextToken", this.nextToken);
        }
        AwsResult awsResult = this.sendWithRetry();
        QueryTimeoutException.check(awsResult);
        this.validate(awsResult);
        LinkedList<MultiMap<String, String>> result = new LinkedList<MultiMap<String, String>>();
        Element selectResult = (Element)awsResult.getDocument().getElementsByTagName("SelectResult").item(0);
        this.nextToken = DomUtils.getChildText(selectResult, "NextToken");
        for (Element eachItem : DomUtils.getChildElements((Node)selectResult, "Item")) {
            MultiMap<String, String> map = new MultiMap<String, String>();
            String itemName = DomUtils.getChildText(eachItem, "Name");
            map.addValue("ItemName", itemName);
            NodeList nodeList = eachItem.getElementsByTagName("Attribute");
            for (int n = 0; n < nodeList.getLength(); ++n) {
                Element pair = (Element)nodeList.item(n);
                String name = pair.getElementsByTagName("Name").item(0).getTextContent();
                String value = pair.getElementsByTagName("Value").item(0).getTextContent();
                map.addValue(name, value);
            }
            result.add(map);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/prosc/aws/simpledb/SelectRequest", "<init>"));
    }
}

