/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.simpledb;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.ConditionalCheckFailedException;
import com.prosc.aws.simpledb.SimpleDbRequest;
import java.io.IOException;

public class PutAttributesRequest
extends SimpleDbRequest {
    private int attributeIndex = 0;

    public PutAttributesRequest(Signer signer, boolean encrypt, String domain, String itemName) {
        super(signer, encrypt);
        this.setQueryParam("Action", "PutAttributes");
        this.setQueryParam("DomainName", domain);
        this.setQueryParam("ItemName", itemName);
    }

    public PutAttributesRequest setAttribute(String name, String value) {
        if (value != null) {
            this.addAttribute(name, value);
            this.setQueryParam("Attribute." + this.attributeIndex + ".Replace", "true");
        }
        return this;
    }

    public PutAttributesRequest addAttribute(String name, String value) {
        if (value != null) {
            ++this.attributeIndex;
            this.setQueryParam("Attribute." + this.attributeIndex + ".Name", name);
            this.setQueryParam("Attribute." + this.attributeIndex + ".Value", value);
        }
        return this;
    }

    public PutAttributesRequest requireCondition(String name, String value, boolean mustExist) {
        this.setQueryParam("Expected.Name", name);
        if (value.length() < 100) {
            this.setQueryParam("Expected.Value", value);
        } else {
            this.setQueryParam("Expected.Value", value);
        }
        if (mustExist) {
            this.setQueryParam("Expected.Exists", "true");
        }
        return this;
    }

    public PutAttributesRequest requireNonExistence(String name) {
        this.setQueryParam("Expected.Name", name);
        this.setQueryParam("Expected.Exists", "false");
        return this;
    }

    public void call() throws IOException, ConditionalCheckFailedException {
        AwsResult awsResult = this.sendWithRetry();
        ConditionalCheckFailedException.check(awsResult, this);
        this.validate(awsResult);
    }
}

