/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.simpledb;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.simpledb.SimpleDbRequest;
import com.prosc.xml.DomUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ListDomains
extends SimpleDbRequest {
    public ListDomains(@NotNull Signer signer, boolean encrypt) {
        if (signer == null) {
            ListDomains.$$$reportNull$$$0(0);
        }
        super(signer, encrypt);
        this.setQueryParam("Action", "ListDomains");
    }

    public Iterator<String> call() throws IOException {
        AwsResult awsResult = this.sendWithRetry();
        this.validate(awsResult);
        LinkedList<String> result = new LinkedList<String>();
        for (Element domainsElement : DomUtils.getChildElements(awsResult.getDocument().getElementsByTagName("ListDomainsResult").item(0), "DomainName")) {
            result.add(domainsElement.getTextContent());
        }
        String nextToken = null;
        NodeList nodeList = awsResult.getDocument().getElementsByTagName("NextToken");
        if (nodeList.getLength() == 1) {
            nextToken = nodeList.item(0).getTextContent();
        }
        if (nextToken != null) {
            throw new IllegalStateException("There are more domains than can be returned; need to fix ListDomains to stream the results");
        }
        return result.iterator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signer", "com/prosc/aws/simpledb/ListDomains", "<init>"));
    }
}

