/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.simpledb;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.NoSuchDomainException;
import com.prosc.aws.simpledb.SimpleDbRequest;
import com.prosc.data.MultiMap;
import com.prosc.xml.DomUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.Element;

public class GetAttributesRequest
extends SimpleDbRequest {
    public GetAttributesRequest(Signer signer, boolean encrypt, String domain, String itemName, boolean consistentRead) {
        super(signer, encrypt);
        this.setQueryParam("Action", "GetAttributes");
        this.setQueryParam("DomainName", domain);
        this.setQueryParam("ConsistentRead", String.valueOf(consistentRead));
        this.setQueryParam("ItemName", itemName);
    }

    public GetAttributesRequest setAttributes(String ... attributeNames) {
        int index = 0;
        for (String name : attributeNames) {
            this.setQueryParam("AttributeName." + index++, name);
        }
        return this;
    }

    public Optional<MultiMap<String, String>> call() throws IOException, NoSuchDomainException {
        AwsResult awsResult = this.sendWithRetry();
        this.validate(awsResult);
        MultiMap<String, String> result = new MultiMap<String, String>();
        Map<String, String> queryParams = this.getQueryParams();
        result.addValue("ItemName", queryParams.get("ItemName"));
        Iterable<Element> childElements = DomUtils.getChildElements(awsResult.getDocument().getElementsByTagName("GetAttributesResult").item(0), "Attribute");
        if (childElements.iterator().hasNext()) {
            for (Element attributeResult : childElements) {
                String name = attributeResult.getElementsByTagName("Name").item(0).getTextContent();
                String value = attributeResult.getElementsByTagName("Value").item(0).getTextContent();
                result.addValue(name, value);
            }
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

