/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.simpledb;

import com.prosc.aws.Region;
import com.prosc.aws.Signer;
import com.prosc.aws.simpledb.SimpleDbRequest;
import com.prosc.thread.MyThreadFactory;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class BatchPutAttributesRequest {
    private static final Logger log = Logger.getLogger(BatchPutAttributesRequest.class.getName());
    private final Signer signer;
    private final boolean encrypt;
    private final String domain;
    private final ExecutorService sendingThreads;
    private final List<Future<Void>> waitingBatches;
    private Region region;
    private SingleBatchPutAttributesRequest currentBatch;

    public BatchPutAttributesRequest(@NotNull Signer signer, boolean encrypt, String domain, int threadCount) {
        if (signer == null) {
            BatchPutAttributesRequest.$$$reportNull$$$0(0);
        }
        this.waitingBatches = new LinkedList<Future<Void>>();
        this.region = null;
        this.signer = signer;
        this.encrypt = encrypt;
        this.domain = domain;
        this.sendingThreads = Executors.newFixedThreadPool(threadCount, new MyThreadFactory("SimpleDB batch writer"));
        this.initializeCurrentBatch();
    }

    public void setRegion(Region region) {
        this.region = region;
        this.currentBatch.setRegion(region);
    }

    public BatchPutAttributesRequest addItem(String itemName) {
        if (this.currentBatch.isFull()) {
            final SingleBatchPutAttributesRequest batchToSend = this.currentBatch;
            this.waitingBatches.add(this.sendingThreads.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    batchToSend.call();
                    return null;
                }
            }));
            this.initializeCurrentBatch();
        }
        this.currentBatch.addItem(itemName);
        return this;
    }

    public BatchPutAttributesRequest setAttribute(String name, String value) {
        this.currentBatch.setAttribute(name, value);
        return this;
    }

    public BatchPutAttributesRequest addAttribute(String name, String value) {
        this.currentBatch.addAttribute(name, value);
        return this;
    }

    public void call() throws IOException {
        this.waitingBatches.add(this.sendingThreads.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BatchPutAttributesRequest.this.currentBatch.call();
                return null;
            }
        }));
        for (Future<Void> waitingBatch : this.waitingBatches) {
            boolean wasInterrupted = false;
            try {
                while (true) {
                    try {
                        waitingBatch.get();
                    }
                    catch (InterruptedException e) {
                        wasInterrupted = true;
                        log.log(Level.WARNING, "Processing thread was interrupted, but all SimpleDB batch operations must conclude first. Ignoring interruption.", e);
                        continue;
                    }
                    break;
                }
            }
            catch (ExecutionException e) {
                log.log(Level.SEVERE, "Batch put operation failed! Proceeding with other batches normally.", e);
            }
            if (!wasInterrupted) continue;
            Thread.currentThread().interrupt();
        }
        this.sendingThreads.shutdown();
    }

    private void initializeCurrentBatch() {
        this.currentBatch = new SingleBatchPutAttributesRequest(this.signer, this.encrypt, this.domain);
        this.currentBatch.setRegion(this.region);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signer", "com/prosc/aws/simpledb/BatchPutAttributesRequest", "<init>"));
    }

    private static class SingleBatchPutAttributesRequest
    extends SimpleDbRequest {
        private static final int ITEMS_PER_BATCH = 25;
        private int itemIndex;
        private int attributeIndex;

        public SingleBatchPutAttributesRequest(@NotNull Signer signer, boolean encrypt, String domainName) {
            if (signer == null) {
                SingleBatchPutAttributesRequest.$$$reportNull$$$0(0);
            }
            super(signer, encrypt);
            this.itemIndex = 0;
            this.attributeIndex = 0;
            this.setQueryParam("Action", "BatchPutAttributes");
            this.setQueryParam("DomainName", domainName);
        }

        boolean isFull() {
            return this.itemIndex == 25;
        }

        public void call() throws IOException {
            if (this.itemIndex > 0) {
                log.fine("Sending batch with " + this.itemIndex + " items from thread " + Thread.currentThread().getName());
                this.validate(this.sendWithRetry());
            }
        }

        public void addItem(String itemName) {
            if (this.itemIndex == 25) {
                throw new IllegalStateException("BatchPutAttributesRequest already has " + this.itemIndex + " items; cannot hold any more.");
            }
            ++this.itemIndex;
            this.attributeIndex = 0;
            this.setQueryParam("Item." + this.itemIndex + ".ItemName", itemName);
        }

        public void setAttribute(String name, String value) {
            this.addAttribute(name, value);
            this.setQueryParam("Item." + this.itemIndex + ".Attribute." + this.attributeIndex + ".Replace", "true");
        }

        public void addAttribute(String name, String value) {
            ++this.attributeIndex;
            this.setQueryParam("Item." + this.itemIndex + ".Attribute." + this.attributeIndex + ".Name", name);
            this.setPostParam("Item." + this.itemIndex + ".Attribute." + this.attributeIndex + ".Value", value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signer", "com/prosc/aws/simpledb/BatchPutAttributesRequest$SingleBatchPutAttributesRequest", "<init>"));
        }
    }
}

