/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.simpledb;

import com.prosc.aws.Region;
import com.prosc.aws.Signer;
import com.prosc.aws.simpledb.BatchPutAttributesRequest;
import com.prosc.aws.simpledb.SimpleDbRequest;
import com.prosc.thread.MyThreadFactory;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class BatchDeleteAttributesRequest {
    private static final Logger log = Logger.getLogger(BatchPutAttributesRequest.class.getName());
    private final Signer signer;
    private final boolean encrypt;
    private final String domain;
    private final ExecutorService sendingThreads;
    private final List<Future<Void>> waitingBatches;
    private Region region;
    private SingleBatchDeleteAttributesRequest currentBatch;

    public BatchDeleteAttributesRequest(@NotNull Signer signer, boolean encrypt, String domain, int threadCount) {
        if (signer == null) {
            BatchDeleteAttributesRequest.$$$reportNull$$$0(0);
        }
        this.waitingBatches = new LinkedList<Future<Void>>();
        this.region = null;
        this.signer = signer;
        this.encrypt = encrypt;
        this.domain = domain;
        this.sendingThreads = Executors.newFixedThreadPool(threadCount, new MyThreadFactory("SimpleDB batch deleter"));
        this.initializeCurrentBatch();
    }

    public void setRegion(Region region) {
        this.region = region;
        this.currentBatch.setRegion(region);
    }

    public BatchDeleteAttributesRequest addItem(String itemName) {
        if (this.currentBatch.isFull()) {
            final SingleBatchDeleteAttributesRequest batchToSend = this.currentBatch;
            this.waitingBatches.add(this.sendingThreads.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    batchToSend.call();
                    return null;
                }
            }));
            this.initializeCurrentBatch();
        }
        this.currentBatch.addItem(itemName);
        return this;
    }

    public BatchDeleteAttributesRequest deleteAttribute(String name) {
        this.currentBatch.deleteAttribute(name);
        return this;
    }

    public BatchDeleteAttributesRequest deleteAttribute(String name, String value) {
        this.currentBatch.deleteAttributeValue(name, value);
        return this;
    }

    private void initializeCurrentBatch() {
        this.currentBatch = new SingleBatchDeleteAttributesRequest(this.signer, this.encrypt, this.domain);
        this.currentBatch.setRegion(this.region);
    }

    public void call() throws IOException {
        this.waitingBatches.add(this.sendingThreads.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BatchDeleteAttributesRequest.this.currentBatch.call();
                return null;
            }
        }));
        for (Future<Void> waitingBatch : this.waitingBatches) {
            boolean wasInterrupted = false;
            try {
                while (true) {
                    try {
                        waitingBatch.get();
                    }
                    catch (InterruptedException e) {
                        wasInterrupted = true;
                        log.log(Level.WARNING, "Processing thread was interrupted, but all SimpleDB batch operations must conclude first. Ignoring interruption.", e);
                        continue;
                    }
                    break;
                }
            }
            catch (ExecutionException e) {
                log.log(Level.SEVERE, "Batch delete operation failed! Proceeding with other batches normally.", e);
            }
            if (!wasInterrupted) continue;
            Thread.currentThread().interrupt();
        }
        this.sendingThreads.shutdown();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signer", "com/prosc/aws/simpledb/BatchDeleteAttributesRequest", "<init>"));
    }

    private static class SingleBatchDeleteAttributesRequest
    extends SimpleDbRequest {
        private static final int ITEMS_PER_BATCH = 25;
        private int itemIndex;
        private int attributeIndex;

        public SingleBatchDeleteAttributesRequest(@NotNull Signer signer, boolean encrypt, String domainName) {
            if (signer == null) {
                SingleBatchDeleteAttributesRequest.$$$reportNull$$$0(0);
            }
            super(signer, encrypt);
            this.itemIndex = 0;
            this.attributeIndex = 0;
            this.setQueryParam("Action", "BatchDeleteAttributes");
            this.setQueryParam("DomainName", domainName);
        }

        boolean isFull() {
            return this.itemIndex == 25;
        }

        public void call() throws IOException {
            if (this.itemIndex > 0) {
                log.info("Deleting batch with " + this.itemIndex + " items from domain '" + this.getParam("DomainName") + "' in thread " + Thread.currentThread().getName());
                this.validate(this.sendWithRetry());
            }
        }

        public void addItem(String itemName) {
            if (this.itemIndex == 25) {
                throw new IllegalStateException("BatchDeleteAttributesRequest already has " + this.itemIndex + " items; cannot hold any more.");
            }
            ++this.itemIndex;
            this.attributeIndex = 0;
            this.setQueryParam("Item." + this.itemIndex + ".ItemName", itemName);
        }

        public void deleteAttribute(String name) {
            ++this.attributeIndex;
            this.setQueryParam("Item." + this.itemIndex + ".Attribute." + this.attributeIndex + ".Name", name);
        }

        public void deleteAttributeValue(String name, String value) {
            this.deleteAttribute(name);
            this.setQueryParam("Item." + this.itemIndex + ".Attribute." + this.attributeIndex + ".Value", value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signer", "com/prosc/aws/simpledb/BatchDeleteAttributesRequest$SingleBatchDeleteAttributesRequest", "<init>"));
        }
    }
}

