/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.ses;

import com.prosc.aws.Signer;
import com.prosc.aws.exception.AccessDeniedException;
import com.prosc.aws.exception.SESException;
import com.prosc.aws.ses.AbstractEmailSender;
import com.prosc.aws.ses.EmailResult;
import com.prosc.aws.simpledb.CreateDomainRequest;
import com.prosc.aws.simpledb.PutAttributesRequest;
import com.prosc.infrastructure.LogUtils;
import java.io.IOException;
import java.util.Date;

public class SimpleEmailSender
extends AbstractEmailSender<SimpleEmailSender> {
    private final boolean logEmail;
    private int replyToCount = 0;
    private volatile boolean didCreateDomain = false;

    public SimpleEmailSender(Signer signer) {
        this(signer, false);
    }

    public SimpleEmailSender(Signer signer, boolean logEmailToSimpleDB) {
        super(signer);
        this.logEmail = logEmailToSimpleDB;
        this.setQueryParam("Action", "SendEmail");
    }

    public SimpleEmailSender addReplyTo(String replyTo) {
        this.setQueryParam("ReplyToAddresses.member." + ++this.replyToCount, replyTo);
        return this;
    }

    public SimpleEmailSender setBodyText(String body) {
        return this.setBodyText(body, "utf-8");
    }

    public SimpleEmailSender setBodyText(String body, String charset) {
        this.setPostParam("Message.Body.Text.Data", body);
        this.setQueryParam("Message.Body.Text.Charset", charset);
        return this;
    }

    public SimpleEmailSender setBodyHtml(String html) {
        return this.setBodyHtml(html, "utf-8");
    }

    public SimpleEmailSender setBodyHtml(String html, String charset) {
        this.setPostParam("Message.Body.Html.Data", html);
        this.setQueryParam("Message.Body.Html.Charset", charset);
        return this;
    }

    public SimpleEmailSender setSubject(String subject) {
        return this.setSubject(subject, "utf-8");
    }

    public SimpleEmailSender setSubject(String subject, String charset) {
        this.setQueryParam("Message.Subject.Data", subject);
        this.setQueryParam("Message.Subject.Charset", charset);
        return this;
    }

    @Override
    public SimpleEmailSender addRecipientTo(String recipient) {
        super.addRecipientTo(recipient);
        return this;
    }

    @Override
    public SimpleEmailSender setFrom(String from) {
        super.setFrom(from);
        return this;
    }

    @Override
    public EmailResult call() throws IOException, SESException {
        final EmailResult result = super.call();
        if (this.logEmail) {
            Thread logEmailThread = new Thread("Log SimpleEmailSender"){

                @Override
                public void run() {
                    try {
                        String externalIp = LogUtils.getExternalAddress(false);
                        if (!SimpleEmailSender.this.didCreateDomain) {
                            new CreateDomainRequest(SimpleEmailSender.this.getSigner(), false, "SimpleEmailSenderLog").call();
                            SimpleEmailSender.this.didCreateDomain = true;
                        }
                        PutAttributesRequest simpleDb = new PutAttributesRequest(SimpleEmailSender.this.getSigner(), true, "SimpleEmailSenderLog", result.getMessageId()).setAttribute("timestamp", new Date().toString()).setAttribute("ipAddress", externalIp).setAttribute("source", SimpleEmailSender.this.getFrom()).setAttribute("firstRecipient", SimpleEmailSender.this.getFirstRecipient()).setAttribute("subject", (String)SimpleEmailSender.this.getParam("Message.Subject.Data"));
                        if (SimpleEmailSender.this.getSigner() != null) {
                            simpleDb.setAttribute("accessKey", SimpleEmailSender.this.getSigner().getAccessKey());
                        }
                        simpleDb.call();
                    }
                    catch (AccessDeniedException externalIp) {
                    }
                    catch (Throwable t) {
                        System.err.println("Outbound email message " + result.getMessageId() + " could not be logged: " + t.toString());
                    }
                }
            };
            logEmailThread.setDaemon(false);
            logEmailThread.start();
        }
        return result;
    }
}

