/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.ses;

import com.prosc.aws.AwsResult;
import com.prosc.aws.ResponseStyle;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.MessageRejectedException;
import com.prosc.aws.exception.SESException;
import com.prosc.aws.ses.EmailResult;
import com.prosc.aws.ses.SimpleEmailSender;
import com.prosc.io.IOUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SimpleEmailProxySender
extends SimpleEmailSender {
    private static final URL PROXY_URL;
    private static final int TEN_MEGABYTES = 0xA00000;

    public SimpleEmailProxySender() {
        super(new Signer("fakeAccessKey", "fakeSecretKey"), false);
    }

    @Override
    protected AwsResult _send(String nextToken) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)PROXY_URL.openConnection();
        connection.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestMethod("POST");
        String timestamp = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssZ", Locale.US).format(new Date());
        this.setQueryParam("Timestamp", timestamp);
        byte[] payloadBytes = IOUtils.urlEncodeMap(this.getAllParams()).getBytes(StandardCharsets.UTF_8);
        if (payloadBytes.length > 0xA00000) {
            throw new IOException("SES Proxy sender payload size is " + payloadBytes.length + "; cannot exceed 10 megabytes", null);
        }
        connection.setDoOutput(true);
        try (OutputStream out = connection.getOutputStream();){
            out.write(payloadBytes);
        }
        return new AwsResult(connection, ResponseStyle.xml, ResponseStyle.json, this).download();
    }

    @Override
    public EmailResult call() throws IOException, SESException {
        AwsResult awsResult = this.sendWithRetry(null, null);
        MessageRejectedException.check(awsResult, (String)this.getParam("Source"));
        SESException.check(awsResult);
        awsResult.validate();
        return new EmailResult(awsResult.getDocument().getDocumentElement());
    }

    static {
        try {
            PROXY_URL = new URL("https://api.360works.com/SendEmail");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

