/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.ses;

import com.prosc.xml.DomUtils;
import java.math.BigDecimal;
import org.w3c.dom.Element;

public class SendQuota {
    private final int sentLast24Hours;
    private final float intValue;
    private final int maxSendRate;

    SendQuota(Element xml) {
        this.sentLast24Hours = new BigDecimal(DomUtils.getChildText(xml, "SentLast24Hours")).intValue();
        this.intValue = new BigDecimal(DomUtils.getChildText(xml, "Max24HourSend")).intValue();
        this.maxSendRate = new BigDecimal(DomUtils.getChildText(xml, "MaxSendRate")).intValue();
    }

    public int getSentLast24Hours() {
        return this.sentLast24Hours;
    }

    public float getIntValue() {
        return this.intValue;
    }

    public int getMaxSendRate() {
        return this.maxSendRate;
    }

    public String toString() {
        return "SendQuota{sentLast24Hours=" + this.sentLast24Hours + ", intValue=" + this.intValue + ", maxSendRate=" + this.maxSendRate + '}';
    }

    public boolean isProductionMode() {
        return this.maxSendRate >= 10;
    }
}

