/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.ses;

import com.prosc.aws.AwsRequest;
import com.prosc.aws.AwsResult;
import com.prosc.aws.Region;
import com.prosc.aws.ResponseStyle;
import com.prosc.aws.Signer;
import com.prosc.io.IOUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.jetbrains.annotations.Nullable;

abstract class SESRequest
extends AwsRequest<SESRequest> {
    public SESRequest(@Nullable Signer signer) {
        super(signer);
        this.setQueryParam("Version", "2010-12-01");
    }

    @Override
    protected final AwsResult _send(String nextToken) throws IOException {
        Region sesRegion;
        switch (this.getRegion()) {
            case saEast1: 
            case usEast1: {
                sesRegion = Region.usEast1;
                break;
            }
            case euCentral1: 
            case euWest1: {
                sesRegion = Region.euWest1;
                break;
            }
            case euNorth1: {
                sesRegion = Region.euNorth1;
                break;
            }
            case apNortheast1: 
            case apSoutheast1: 
            case apSoutheast2: 
            case usWest1: 
            case usWest2: {
                sesRegion = Region.usWest2;
                break;
            }
            default: {
                sesRegion = Region.usEast1;
            }
        }
        String queryString = IOUtils.urlEncodeMap(this.getAllParams());
        URL url = new URL("https://email." + sesRegion.code + ".amazonaws.com/?" + queryString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setUseCaches(false);
        if (this.getSigner() == null) {
            throw new IllegalStateException("Signer must not be null");
        }
        this.getSigner().signRequestV4(connection, this.getRegion(), "ses", this, this.getQueryParams(), null);
        return new AwsResult(connection, ResponseStyle.xml, this).download();
    }
}

