/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.ses;

import com.prosc.aws.Signer;
import com.prosc.aws.ses.AbstractEmailSender;
import com.prosc.shared.ProscMail;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class RawEmailSender
extends AbstractEmailSender<RawEmailSender>
implements ProscMail.Sender {
    public RawEmailSender(Signer signer) {
        super(signer);
        this.setQueryParam("Action", "SendRawEmail");
    }

    public RawEmailSender setRawMessage(byte[] rawMessageBytes) {
        this.setPostParam("RawMessage.Data", Base64.getEncoder().encodeToString(rawMessageBytes));
        return this;
    }

    @Override
    public void sendMessage(MimeMessage msg, Properties p) throws MessagingException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            msg.writeTo(baos);
            this.setRawMessage(baos.toByteArray());
            this.sendWithRetry();
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to send " + msg, e);
        }
    }
}

