/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.ses;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.ses.SESRequest;
import com.prosc.xml.DomUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetIdentityVerificationAttributes
extends SESRequest {
    private int identityCount = 0;

    public GetIdentityVerificationAttributes(Signer signer) {
        super(signer);
        this.setQueryParam("Action", "GetIdentityVerificationAttributes");
    }

    public GetIdentityVerificationAttributes(Signer signer, String ... identities) {
        this(signer);
        for (String identity : identities) {
            this.addIdentity(identity);
        }
    }

    public GetIdentityVerificationAttributes addIdentity(String identity) {
        int index = ++this.identityCount;
        this.setQueryParam("Identities.member." + index, identity);
        return this;
    }

    public Map<String, String> call() throws IOException {
        AwsResult awsResult = this.sendWithRetry();
        awsResult.validate();
        Node verificationAttributes = awsResult.getDocument().getElementsByTagName("VerificationAttributes").item(0);
        if (verificationAttributes == null) {
            return Collections.emptyMap();
        }
        NodeList nodeList = verificationAttributes.getChildNodes();
        HashMap<String, String> result = new HashMap<String, String>(nodeList.getLength());
        for (int n = 0; n < nodeList.getLength(); ++n) {
            Node node = nodeList.item(n);
            if (!(node instanceof Element)) continue;
            Element entry = (Element)node;
            String key = DomUtils.getChildText(entry, "key");
            String value = DomUtils.getRecursiveChildText(entry, "VerificationStatus");
            result.put(key, value);
        }
        return result;
    }
}

