/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.ses;

import com.prosc.aws.AwsLogHandler;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.SESException;
import com.prosc.aws.ses.SimpleEmailProxySender;
import com.prosc.aws.ses.SimpleEmailSender;
import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.util.logging.LogManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmailSESLogHandler
extends AwsLogHandler {
    private static final String TO_ADDRESS_KEY;
    private static final String FROM_ADDRESS_KEY;
    private static final String ACCESS_KEY;
    private static final String SECRET_KEY;
    @NotNull
    private final String toAddress;
    private final String fromAddress;
    private final Signer signer;
    private final boolean logEmail;
    private String replyAddress;

    public EmailSESLogHandler() {
        super(true);
        LogManager manager = LogManager.getLogManager();
        String _toAddress = manager.getProperty(TO_ADDRESS_KEY);
        if (_toAddress == null) {
            throw new IllegalArgumentException("You must set the " + TO_ADDRESS_KEY + " property in the log configuration file.");
        }
        this.toAddress = _toAddress;
        this.fromAddress = manager.getProperty(FROM_ADDRESS_KEY);
        if (this.fromAddress == null) {
            throw new IllegalArgumentException("You must set the " + FROM_ADDRESS_KEY + " property in the log configuration file.");
        }
        String accessKey = manager.getProperty(ACCESS_KEY);
        if (accessKey == null) {
            throw new IllegalArgumentException("You must set the " + ACCESS_KEY + " property in the log configuration file.");
        }
        String secretKey = manager.getProperty(SECRET_KEY);
        if (secretKey == null) {
            throw new IllegalArgumentException("You must set the " + SECRET_KEY + " property in the log configuration file.");
        }
        this.signer = new Signer(accessKey, secretKey);
        this.logEmail = false;
    }

    public EmailSESLogHandler(@Nullable Signer signer, @NotNull String fromAddress, @NotNull String toAddress, boolean autoflush, boolean logEmail) {
        if (fromAddress == null) {
            EmailSESLogHandler.$$$reportNull$$$0(0);
        }
        if (toAddress == null) {
            EmailSESLogHandler.$$$reportNull$$$0(1);
        }
        super(autoflush);
        this.toAddress = toAddress;
        this.fromAddress = fromAddress;
        this.signer = signer;
        this.logEmail = logEmail;
    }

    public EmailSESLogHandler(@Nullable Signer signer, @NotNull String fromAddress, @NotNull String toAddress, boolean autoflush) {
        if (fromAddress == null) {
            EmailSESLogHandler.$$$reportNull$$$0(2);
        }
        if (toAddress == null) {
            EmailSESLogHandler.$$$reportNull$$$0(3);
        }
        this(signer, fromAddress, toAddress, autoflush, false);
    }

    @Override
    protected void publish(StringBuilder sb) throws IOException, SESException {
        if (this.toAddress.length() == 0) {
            return;
        }
        SimpleEmailSender sender = this.signer == null ? new SimpleEmailProxySender() : new SimpleEmailSender(this.signer, this.logEmail);
        sender.setSubject(this.getSubject());
        sender.addRecipientTo(this.toAddress);
        sender.setFrom(this.fromAddress);
        if (!StringUtils.isEmpty(this.replyAddress)) {
            sender.addReplyTo(this.replyAddress);
        }
        sender.setBodyText(sb.toString(), "utf-8");
        sender.call();
    }

    public void setReplyAddress(String replyAddress) {
        this.replyAddress = replyAddress;
    }

    static {
        String className = EmailSESLogHandler.class.getName();
        TO_ADDRESS_KEY = className + ".to";
        FROM_ADDRESS_KEY = className + ".from";
        ACCESS_KEY = className + ".accessKey";
        SECRET_KEY = className + ".secretKey";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fromAddress";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "toAddress";
                break;
            }
        }
        objectArray[1] = "com/prosc/aws/ses/EmailSESLogHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

