/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.ses;

import com.prosc.aws.AwsRequest;
import com.prosc.aws.AwsResult;
import com.prosc.aws.Region;
import com.prosc.aws.ResponseStyle;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.MessageRejectedException;
import com.prosc.aws.exception.SESException;
import com.prosc.aws.ses.EmailResult;
import com.prosc.io.IOUtils;
import com.prosc.shared.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEmailSender<T extends AbstractEmailSender>
extends AwsRequest<T> {
    private static final ReentrantReadWriteLock SES_THROTTLING_LOCK = new ReentrantReadWriteLock(false);
    protected final URL url;
    private int toCount;
    private int bccCount;
    private int ccCount;

    protected AbstractEmailSender(@NotNull Signer signer) {
        if (signer == null) {
            AbstractEmailSender.$$$reportNull$$$0(0);
        }
        super(signer);
        this.toCount = 0;
        this.bccCount = 0;
        this.ccCount = 0;
        Region region = signer.getDefaultRegion();
        if (region == null) {
            region = Region.usEast1;
        }
        this.url = IOUtils.toUrl("https://email." + region.code + ".amazonaws.com");
    }

    public T addCcTo(String recipient) {
        String[] parts;
        for (String part : parts = recipient.split(",")) {
            int newIndex;
            String trim = part.trim();
            if (StringUtils.isEmpty(trim) || (newIndex = ++this.ccCount + this.bccCount + this.toCount) <= 50) continue;
            throw new IllegalStateException("You cannot specify more than 50 recipients with Amazon Simple Email Service");
        }
        return (T)this;
    }

    public T addBccTo(String recipient) {
        String[] parts;
        for (String part : parts = recipient.split(",")) {
            int newIndex;
            String trim = part.trim();
            if (StringUtils.isEmpty(trim) || (newIndex = ++this.bccCount + this.toCount + this.ccCount) <= 50) continue;
            throw new IllegalStateException("You cannot specify more than 50 recipients with Amazon Simple Email Service");
        }
        return (T)this;
    }

    public T addRecipientTo(String recipient) {
        String[] parts;
        for (String part : parts = recipient.split(",")) {
            int newIndex;
            String trim = part.trim();
            if (StringUtils.isEmpty(trim)) continue;
            if ((newIndex = ++this.toCount) > 50) {
                throw new IllegalStateException("You cannot specify more than 50 recipients with Amazon Simple Email Service");
            }
            this.setQueryParam("Destination.ToAddresses.member." + newIndex, trim);
        }
        return (T)this;
    }

    public String getFirstRecipient() {
        return (String)this.getParam("Destination.ToAddresses.member.1");
    }

    public T setFrom(String from) {
        this.setQueryParam("Source", from);
        return (T)this;
    }

    public String getFrom() {
        return (String)this.getParam("Source");
    }

    public EmailResult call() throws IOException, SESException {
        AwsResult awsResult = this.sendWithRetry(SES_THROTTLING_LOCK, null);
        MessageRejectedException.check(awsResult, (String)this.getParam("Source"));
        SESException.check(awsResult);
        awsResult.validate();
        return new EmailResult(awsResult.getDocument().getDocumentElement());
    }

    @Override
    protected AwsResult _send(String nextToken) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        connection.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestMethod("POST");
        String timestamp = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssZ", Locale.US).format(new Date());
        this.setPostParam("Timestamp", timestamp);
        byte[] payloadBytes = IOUtils.urlEncodeMap(this.getAllParams()).getBytes(StandardCharsets.UTF_8);
        this.getSigner().signRequestV4(connection, this.getRegion(), "ses", this, this.getQueryParams(), new ByteArrayInputStream(payloadBytes));
        connection.setDoOutput(true);
        try (OutputStream out = connection.getOutputStream();){
            out.write(payloadBytes);
        }
        return new AwsResult(connection, ResponseStyle.xml, this).download();
    }

    @Override
    public String toString() {
        return "SimpleEmailSender{url=" + this.url + ", params=" + this.getParamDescriptionTruncated() + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signer", "com/prosc/aws/ses/AbstractEmailSender", "<init>"));
    }
}

