/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.iam;

import com.prosc.aws.AwsResult;
import com.prosc.aws.Signer;
import com.prosc.aws.iam.IamRequest;
import com.prosc.aws.iam.InstanceProfile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ListInstanceProfilesRequest
extends IamRequest {
    public ListInstanceProfilesRequest(@NotNull Signer signer, @Nullable String path) {
        if (signer == null) {
            ListInstanceProfilesRequest.$$$reportNull$$$0(0);
        }
        super(signer);
        this.setQueryParam("Action", "ListInstanceProfiles");
        this.setQueryParam("MaxItems", "1000");
        if (path != null) {
            this.setQueryParam("Path", path);
        }
    }

    public List<InstanceProfile> call() throws IOException {
        AwsResult awsResult = this.sendWithRetry();
        this.validate(awsResult);
        awsResult.validate();
        Node instanceProfiles = awsResult.getDocument().getElementsByTagName("InstanceProfiles").item(0);
        if (instanceProfiles == null) {
            return Collections.emptyList();
        }
        NodeList nodeList = instanceProfiles.getChildNodes();
        ArrayList<InstanceProfile> result = new ArrayList<InstanceProfile>(nodeList.getLength());
        for (int n = 0; n < nodeList.getLength(); ++n) {
            Node node = nodeList.item(n);
            if (!(node instanceof Element)) continue;
            result.add(new InstanceProfile((Element)node));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signer", "com/prosc/aws/iam/ListInstanceProfilesRequest", "<init>"));
    }
}

