/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.iam;

import com.prosc.aws.Signer;
import com.prosc.aws.iam.Role;
import com.prosc.xml.DomUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InstanceProfile {
    private final String instanceProfileId;
    private final String instanceProfileName;
    private final String path;
    private final String arn;
    private final Date createDate;
    private final List<Role> roles;

    InstanceProfile(Element xml) {
        this.instanceProfileId = DomUtils.getChildText(xml, "InstanceProfileId");
        this.instanceProfileName = DomUtils.getChildText(xml, "InstanceProfileName");
        this.path = DomUtils.getChildText(xml, "Path");
        this.arn = DomUtils.getChildText(xml, "Arn", false);
        this.createDate = Signer.parseDateTime(DomUtils.getChildText(xml, "CreateDate", false));
        NodeList nodeList = xml.getElementsByTagName("Roles").item(0).getChildNodes();
        this.roles = new ArrayList<Role>(nodeList.getLength());
        for (int n = 0; n < nodeList.getLength(); ++n) {
            Node node = nodeList.item(n);
            if (!(node instanceof Element)) continue;
            this.roles.add(new Role((Element)node));
        }
    }

    public String getInstanceProfileId() {
        return this.instanceProfileId;
    }

    public String getInstanceProfileName() {
        return this.instanceProfileName;
    }

    public String getPath() {
        return this.path;
    }

    public String getArn() {
        return this.arn;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public String toString() {
        return "InstanceProfile{instanceProfileId='" + this.instanceProfileId + '\'' + ", instanceProfileName='" + this.instanceProfileName + '\'' + ", path='" + this.path + '\'' + ", arn='" + this.arn + '\'' + ", createDate=" + this.createDate + ", roles=" + this.roles + '}';
    }
}

