/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.iam;

import com.prosc.aws.iam.AccessKey;
import com.prosc.aws.iam.AssumeRoleResult;
import com.prosc.format.UTCTimestampFormat;
import com.prosc.xml.DomUtils;
import java.util.Date;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class AssumeRoleWithWebIdentityResult {
    private static final Logger log = Logger.getLogger(AssumeRoleResult.class.getName());
    private final String sessionToken;
    private final String subject;
    private final String roleArn;
    private final String assumedRoleId;
    private final Date expiration;
    private final String issuer;
    private final String audience;
    private final AccessKey accessKey;
    private final String provider;

    AssumeRoleWithWebIdentityResult(Element dom) {
        this.subject = dom.getElementsByTagName("SubjectFromWebIdentityToken").item(0).getTextContent();
        this.roleArn = dom.getElementsByTagName("Arn").item(0).getTextContent();
        this.assumedRoleId = dom.getElementsByTagName("AssumedRoleId").item(0).getTextContent();
        this.sessionToken = dom.getElementsByTagName("SessionToken").item(0).getTextContent();
        Element credentials = (Element)dom.getElementsByTagName("Credentials").item(0);
        this.accessKey = new AccessKey(credentials);
        this.expiration = new UTCTimestampFormat().parse(credentials.getElementsByTagName("Expiration").item(0).getTextContent());
        this.issuer = DomUtils.getChildText(credentials, "Issuer");
        this.audience = DomUtils.getChildText(credentials, "Audience");
        this.provider = dom.getElementsByTagName("Provider").item(0).getTextContent();
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public String getAssumedRoleId() {
        return this.assumedRoleId;
    }

    public AccessKey getAccessKey() {
        return this.accessKey;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getAudience() {
        return this.audience;
    }

    public String getProvider() {
        return this.provider;
    }

    public String toString() {
        return "RoleResult{sessionToken='" + this.sessionToken + '\'' + ", subject='" + this.subject + '\'' + ", roleArn='" + this.roleArn + '\'' + ", assumedRoleId='" + this.assumedRoleId + '\'' + ", expiration=" + this.expiration + ", issuer='" + this.issuer + '\'' + ", audience='" + this.audience + '\'' + ", accessKey=" + this.accessKey + ", provider='" + this.provider + '\'' + '}';
    }
}

