/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.exception;

import com.prosc.aws.AwsRequest;
import com.prosc.aws.AwsResult;
import com.prosc.aws.exception.AWSRuntimeException;
import com.prosc.xml.DomUtils;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

public class RedirectException
extends AWSRuntimeException {
    private static final Logger log = Logger.getLogger(RedirectException.class.getName());

    public RedirectException(int responseCode, String code, String errorMessage, @Nullable Document parsedXml, AwsRequest<?> request) {
        super(responseCode, code, errorMessage, parsedXml, request);
    }

    public RedirectException(int responseCode, String code, AwsRequest<?> request) {
        super(responseCode, code, request);
    }

    public static void check(AwsResult result, AwsRequest<?> request) {
        int statusCode = result.getHttpStatusCode();
        if (statusCode >= 300 && statusCode < 400 && statusCode != 304) {
            if (result.getDocument() == null) {
                log.warning(result.getUrlConnection().getHeaderFields().toString());
                log.warning(result.getResponseAsString());
                throw new RedirectException(statusCode, "code", request);
            }
            log.warning(DomUtils.dumpXml(result.getDocument(), result.getDocument().getDocumentElement()));
            throw new RedirectException(statusCode, result.getErrorCode(), "Error message goes here", result.getDocument(), request);
        }
    }
}

