/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws.exception;

import com.prosc.aws.AwsRequest;
import com.prosc.aws.AwsResult;
import com.prosc.aws.exception.AWSRuntimeException;
import com.prosc.xml.DomUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class AwsInternalException
extends AWSRuntimeException {
    private static final Logger log = Logger.getLogger(AwsInternalException.class.getName());

    public AwsInternalException(int responseCode, Document parsedXml, AwsRequest request) {
        super(responseCode, parsedXml, request);
    }

    public static void check(AwsResult awsResult, AwsRequest request) throws AwsInternalException {
        if ("InternalError".equals(awsResult.getErrorCode())) {
            AwsInternalException internalException = new AwsInternalException(awsResult.getHttpStatusCode(), awsResult.getDocument(), request);
            log.log(Level.WARNING, "Internal Error XML result: " + DomUtils.dumpXml(awsResult.getDocument(), null), internalException);
            throw internalException;
        }
    }

    @Override
    public boolean isRetry() {
        return true;
    }
}

