/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws;

import com.prosc.aws.AwsRequest;
import com.prosc.aws.InstanceMetadata;
import com.prosc.aws.Region;
import com.prosc.aws.exception.AWSRuntimeException;
import com.prosc.aws.exception.AccessDeniedException;
import com.prosc.aws.iam.AssumeRole;
import com.prosc.aws.iam.AssumeRoleResult;
import com.prosc.aws.iam.Credentials;
import com.prosc.aws.iam.GetRoleRequest;
import com.prosc.aws.iam.GetUserRequest;
import com.prosc.aws.iam.User;
import com.prosc.io.IOUtils;
import com.prosc.security.EncryptionUtils;
import com.prosc.shared.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Signer {
    private static final Logger log = Logger.getLogger(Signer.class.getName());
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    protected static final Charset ENCODING = StandardCharsets.ISO_8859_1;
    private static Signer cachedSigner = null;
    private static String roleName = null;
    private static long cacheExpires = -1L;
    private final String sessionToken;
    @NotNull
    private final String accessKey;
    @NotNull
    private final String secretKey;
    private String userToken;
    private String productToken;
    private Region defaultRegion;
    private boolean sandbox;
    private String awsAccountId;

    public Signer(@NotNull String accessKey, @NotNull String secretKey) {
        if (accessKey == null) {
            Signer.$$$reportNull$$$0(0);
        }
        if (secretKey == null) {
            Signer.$$$reportNull$$$0(1);
        }
        this(accessKey, secretKey, null, null);
    }

    public Signer(@NotNull String accessKey, @NotNull String secretKey, @Nullable String sessionToken) {
        if (accessKey == null) {
            Signer.$$$reportNull$$$0(2);
        }
        if (secretKey == null) {
            Signer.$$$reportNull$$$0(3);
        }
        this(accessKey, secretKey, sessionToken, null);
    }

    public Signer(@NotNull String accessKey, @NotNull String secretKey, @Nullable Region defaultRegion) {
        if (accessKey == null) {
            Signer.$$$reportNull$$$0(4);
        }
        if (secretKey == null) {
            Signer.$$$reportNull$$$0(5);
        }
        this(accessKey, secretKey, null, defaultRegion);
    }

    public Signer(@NotNull String accessKey, @NotNull String secretKey, @Nullable String sessionToken, @Nullable Region defaultRegion) {
        if (accessKey == null) {
            Signer.$$$reportNull$$$0(6);
        }
        if (secretKey == null) {
            Signer.$$$reportNull$$$0(7);
        }
        this.awsAccountId = null;
        if (StringUtils.isEmpty(accessKey)) {
            throw new IllegalArgumentException("Attempted to create a Signer object with a null or empty accessKey");
        }
        if (StringUtils.isEmpty(secretKey)) {
            throw new IllegalArgumentException("Attempted to create a Signer object with a null or empty secretKey");
        }
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.sessionToken = sessionToken;
        this.defaultRegion = defaultRegion;
    }

    @NotNull
    public String getAccessKey() {
        String string = this.accessKey;
        if (string == null) {
            Signer.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getSecretKey() {
        String string = this.secretKey;
        if (string == null) {
            Signer.$$$reportNull$$$0(9);
        }
        return string;
    }

    public String generateHmacSha1String(String payload) {
        byte[] bytes = Signer.generateHmacSha1Bytes(this.secretKey.getBytes(ENCODING), payload.getBytes(ENCODING));
        return Base64.getEncoder().encodeToString(bytes);
    }

    public String getUserToken() {
        return this.userToken;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getProductToken() {
        return this.productToken;
    }

    public void signRequestV4(HttpURLConnection connection, Region region, String serviceName, AwsRequest<?> request, @Nullable byte[] payload) throws IOException {
        this.signRequestV4(connection, region, serviceName, request, payload == null ? null : new ByteArrayInputStream(payload));
    }

    public void signRequestV4(HttpURLConnection connection, Region region, String serviceName, AwsRequest<?> request, @Nullable InputStream payload) throws IOException {
        Map<String, String> queryParams;
        URL url = connection.getURL();
        if (url.getQuery() == null) {
            queryParams = Collections.emptyMap();
        } else {
            String[] keyValues = url.getQuery().split("&");
            queryParams = new HashMap<String, String>(keyValues.length);
            for (String eachParam : keyValues) {
                String value;
                String key;
                int mark1 = eachParam.indexOf(61);
                if (mark1 == -1) {
                    key = eachParam;
                    value = null;
                } else {
                    key = URLDecoder.decode(eachParam.substring(0, mark1), "UTF-8");
                    value = URLDecoder.decode(eachParam.substring(mark1 + 1), "UTF-8");
                }
                queryParams.put(key, value);
            }
        }
        this.signRequestV4(connection, region, serviceName, request, queryParams, payload);
    }

    public void signRequestV4(HttpURLConnection connection, Region region, String serviceName, AwsRequest<?> request, @NotNull Map<String, String> queryParams, @Nullable InputStream payload) throws IOException {
        if (queryParams == null) {
            Signer.$$$reportNull$$$0(10);
        }
        this.signRequestV4(connection, region, serviceName, request, queryParams, payload, false);
    }

    public void signRequestV4(HttpURLConnection connection, Region region, String serviceName, AwsRequest<?> request, @NotNull Map<String, String> queryParams, @Nullable InputStream payload, boolean seedSignature) throws IOException {
        if (queryParams == null) {
            Signer.$$$reportNull$$$0(11);
        }
        this.createV4Signature(connection, region, serviceName, request, queryParams, payload, seedSignature, this.sessionToken);
        String authHeader = "AWS4-HMAC-SHA256 Credential=" + this.accessKey + "/" + request.getSigningResult().credentialScope + ", SignedHeaders=" + request.getSigningResult().signedHeaders + ", Signature=" + request.getSigningResult().signature;
        connection.addRequestProperty("Authorization", authHeader);
        if (this.sessionToken != null) {
            connection.addRequestProperty("X-Amz-Security-Token", this.sessionToken);
        }
    }

    public void createV4Signature(HttpURLConnection connection, Region region, String serviceName, AwsRequest<?> request, @NotNull Map<String, String> queryParams, @Nullable InputStream payload, boolean seedSignature, String sessionToken) throws IOException {
        String payloadHash;
        String dateHeader;
        String canonicalQuery;
        URL url;
        if (queryParams == null) {
            Signer.$$$reportNull$$$0(12);
        }
        if ((url = connection.getURL()).getQuery() == null) {
            canonicalQuery = "";
        } else {
            TreeMap<String, String> sortedParams = new TreeMap<String, String>(queryParams);
            canonicalQuery = IOUtils.urlEncodeMap(sortedParams);
        }
        HashMap<String, List<String>> requestProperties = new HashMap<String, List<String>>(connection.getRequestProperties());
        requestProperties.put("host", Collections.singletonList(url.getHost()));
        TreeMap sortedHeaders = new TreeMap();
        for (Map.Entry entry : requestProperties.entrySet()) {
            String headerName = ((String)entry.getKey()).trim().toLowerCase();
            sortedHeaders.put(headerName, entry.getValue());
        }
        List l = (List)sortedHeaders.get("x-amz-date");
        String dateTimeHeader = l == null || l.size() == 0 ? null : (String)l.get(0);
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateTimeFormat.setTimeZone(UTC);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        dateFormat.setTimeZone(UTC);
        if (dateTimeHeader == null) {
            Date now = new Date();
            dateHeader = dateFormat.format(now);
            dateTimeHeader = dateTimeFormat.format(now);
            sortedHeaders.put("x-amz-date", Collections.singletonList(dateTimeHeader));
            connection.addRequestProperty("x-amz-date", dateTimeHeader);
        } else {
            try {
                dateHeader = dateFormat.format(dateTimeFormat.parse(dateTimeHeader));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("x-amz-date header value is not parseable: " + dateTimeHeader);
            }
        }
        if (sessionToken != null) {
            sortedHeaders.put("x-amz-security-token", Collections.singletonList(sessionToken));
        }
        String allHeadersDelim = "";
        StringBuilder allHeaders = new StringBuilder();
        StringBuilder canonicalHeadersSb = new StringBuilder();
        for (Map.Entry entry : sortedHeaders.entrySet()) {
            String headerName = (String)entry.getKey();
            allHeaders.append(allHeadersDelim).append(headerName);
            allHeadersDelim = ";";
            canonicalHeadersSb.append(headerName + ":");
            String valueDelimiter = "";
            for (String eachValue : (List)entry.getValue()) {
                String trimmedValue = eachValue.trim();
                canonicalHeadersSb.append(valueDelimiter).append(trimmedValue);
                valueDelimiter = ",";
            }
            canonicalHeadersSb.append('\n');
        }
        String canonicalHeaders = canonicalHeadersSb.toString();
        String signedHeaders = allHeaders.toString();
        if (seedSignature) {
            payloadHash = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
        } else {
            if (payload == null) {
                payload = new ByteArrayInputStream(new byte[0]);
            }
            byte[] sha256Digest = EncryptionUtils.generateSHA256Digest(payload);
            payloadHash = EncryptionUtils.toHex(sha256Digest);
        }
        String canonicalPath = url.getPath();
        if (canonicalPath.length() == 0) {
            canonicalPath = "/";
        }
        String canonicalString = connection.getRequestMethod() + '\n' + canonicalPath + '\n' + canonicalQuery + '\n' + canonicalHeaders + '\n' + signedHeaders + '\n' + payloadHash;
        String hashedCanonicalRequest = EncryptionUtils.toHex(EncryptionUtils.generateSHA256Digest(new ByteArrayInputStream(canonicalString.getBytes(StandardCharsets.US_ASCII))));
        String credentialScope = this.getScope(region, serviceName, dateHeader);
        String stringToSign = "AWS4-HMAC-SHA256\n" + dateTimeHeader + '\n' + credentialScope + '\n' + hashedCanonicalRequest;
        byte[] signingKey = this.getSignatureKey(dateHeader, region.code, serviceName);
        byte[] signatureBytes = EncryptionUtils.HmacSHA256(stringToSign.getBytes(StandardCharsets.UTF_8), signingKey);
        String signature = EncryptionUtils.toHex(signatureBytes);
        SigningResult result = new SigningResult();
        result.credentialScope = credentialScope;
        result.signedHeaders = signedHeaders;
        result.signature = signature;
        result.canonicalString = canonicalString;
        request.setSigningResult(result);
    }

    public String getScope(Region region, String serviceName, String dateHeader) {
        return dateHeader + '/' + region.code + '/' + serviceName + "/aws4_request";
    }

    @Deprecated
    public URL signRequestV2WithQueryParams(URL inputUrl, String requestMethod, Map<String, ?> params) throws IOException {
        LinkedHashMap<String, Object> paramsCopy = new LinkedHashMap<String, Object>(params);
        String signature = this.calculateV2Signature(inputUrl, requestMethod, paramsCopy);
        paramsCopy.put("Signature", signature);
        String queryString = IOUtils.urlEncodeMap(paramsCopy);
        return new URL(inputUrl, inputUrl.getPath() + "?" + queryString);
    }

    public void signRequestV2WithHeaders(HttpURLConnection connection, Map<String, Object> queryParams) {
        HashMap<String, Object> queryParamsCopy = new HashMap<String, Object>(queryParams);
        String signature = this.calculateV2Signature(connection.getURL(), connection.getRequestMethod(), queryParamsCopy);
        connection.setRequestProperty("Authorization", "AWS " + this.getAccessKey() + ":" + signature);
        SimpleDateFormat httpDateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z", Locale.US);
        connection.addRequestProperty("x-amz-date", httpDateFormat.format(System.currentTimeMillis()));
    }

    private String calculateV2Signature(URL inputUrl, String requestMethod, Map<String, Object> queryParams) {
        String host = inputUrl.getPort() != -1 && inputUrl.getPort() != inputUrl.getDefaultPort() ? inputUrl.getHost() + ":" + inputUrl.getPort() : inputUrl.getHost();
        String path = inputUrl.getPath().length() == 0 ? "/" : inputUrl.getPath();
        queryParams.put("AWSAccessKeyId", this.accessKey);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        dateFormat.setTimeZone(UTC);
        Date requestDate = new Date();
        queryParams.put("Timestamp", dateFormat.format(requestDate));
        queryParams.put("SignatureVersion", "2");
        queryParams.put("SignatureMethod", "HmacSHA256");
        if (this.sessionToken != null) {
            queryParams.put("SecurityToken", this.sessionToken);
        }
        TreeMap<String, Object> sortedParams = new TreeMap<String, Object>(queryParams);
        String delim = "";
        StringBuilder formattedQueryString = new StringBuilder();
        for (Map.Entry<String, Object> entry : sortedParams.entrySet()) {
            formattedQueryString.append(delim).append(entry.getKey()).append('=').append(AwsRequest.encode(String.valueOf(entry.getValue())));
            delim = "&";
        }
        String canonicalString = requestMethod + "\n" + host.toLowerCase() + "\n" + path + "\n" + formattedQueryString;
        byte[] sha256 = EncryptionUtils.HmacSHA256(canonicalString.getBytes(StandardCharsets.UTF_8), this.secretKey.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(sha256);
    }

    public byte[] getSignatureKey(String dateStamp, String regionName, String serviceName) {
        byte[] kSecret = ("AWS4" + this.secretKey).getBytes(StandardCharsets.UTF_8);
        byte[] kDate = EncryptionUtils.HmacSHA256(dateStamp.getBytes(StandardCharsets.UTF_8), kSecret);
        byte[] kRegion = EncryptionUtils.HmacSHA256(regionName.getBytes(StandardCharsets.UTF_8), kDate);
        byte[] kService = EncryptionUtils.HmacSHA256(serviceName.getBytes(StandardCharsets.UTF_8), kRegion);
        return EncryptionUtils.HmacSHA256("aws4_request".getBytes(StandardCharsets.UTF_8), kService);
    }

    private static byte[] generateHmacSha1Bytes(byte[] amazonSecretKey, byte[] payload) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(amazonSecretKey, "HmacSHA1");
            Mac mac = Mac.getInstance(keySpec.getAlgorithm());
            mac.init(keySpec);
            return mac.doFinal(payload);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDevPayInfo(String userToken, String productToken) {
        this.userToken = userToken;
        this.productToken = productToken;
    }

    public Signer setDefaultRegion(Region defaultRegion) {
        this.defaultRegion = defaultRegion;
        return this;
    }

    @Nullable
    public Region getDefaultRegion() {
        return this.defaultRegion;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public void setSandbox(boolean sandbox) {
        this.sandbox = sandbox;
    }

    public static Signer getSignerForRole() {
        return Signer.getSignerForRole(null, null);
    }

    public static Signer getSignerForRole(@Nullable String roleSessionName, @Nullable String profile) {
        Object roleArn = null;
        String accessKey = System.getProperty("aws.accessKeyId");
        if (accessKey == null) {
            accessKey = System.getProperty("AWS_ACCESS_KEY");
        }
        if (accessKey == null) {
            accessKey = System.getProperty("AWS_ACCESS_KEY_ID");
        }
        if (accessKey == null) {
            accessKey = System.getenv("AWS_ACCESS_KEY_ID");
        }
        log.fine("accessKey: " + accessKey);
        if (cachedSigner != null && cacheExpires > System.currentTimeMillis() && (accessKey == null || accessKey.equals(cachedSigner.getAccessKey()))) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Returning cachedSigner; it is valid until " + new Date(cacheExpires));
            }
            return cachedSigner;
        }
        log.fine("Generating new signer object");
        String secretKey = System.getProperty("aws.secretKey");
        if (secretKey == null) {
            secretKey = System.getProperty("AWS_SECRET_ACCESS_KEY");
        }
        if (secretKey == null) {
            secretKey = System.getenv("AWS_SECRET_ACCESS_KEY");
        }
        String sessionToken = System.getenv("AWS_SESSION_TOKEN");
        log.fine("sessionToken: " + sessionToken);
        if (accessKey == null || secretKey == null) {
            File awsDir;
            File credentialsFile;
            if (accessKey != null) {
                log.warning("An access key property was set, but not a secret key. Be sure to set the AWS_SECRET_ACCESS_KEY system property if you are trying to test outside an EC2 environment.");
            }
            if (secretKey != null) {
                log.warning("A secret key property was set, but not an access key. Be sure to set the AWS_ACCESS_KEY system property if you are trying to test outside an EC2 environment.");
            }
            if ((credentialsFile = new File(awsDir = new File(System.getProperty("user.home"), ".aws"), "credentials")).exists()) {
                List collect;
                try {
                    collect = Files.lines(Paths.get(System.getProperty("user.home"), ".aws", "credentials")).filter(l -> !l.isEmpty()).collect(Collectors.toList());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                for (int i = 0; i < collect.size(); i += 3) {
                    String profileNameInBrackets = ((String)collect.get(i)).trim();
                    String mapAccessKey = StringUtils.textAfter((String)collect.get(i + 1), "=").trim();
                    String mapSecretKey = StringUtils.textAfter((String)collect.get(i + 2), "=").trim();
                    if ((profile != null || !profileNameInBrackets.equalsIgnoreCase("[default]")) && !profileNameInBrackets.equalsIgnoreCase("[" + profile + "]")) continue;
                    accessKey = mapAccessKey;
                    secretKey = mapSecretKey;
                    break;
                }
            }
            if (accessKey == null || secretKey == null) {
                Date expires;
                if (profile != null) {
                    log.warning("The profile provided: " + profile + ", was not found in the credentials file so we will attempt to get from EC2 instance this is running on.");
                }
                if (roleArn == null) {
                    try {
                        if (roleName == null) {
                            try {
                                roleName = InstanceMetadata.getIamRole();
                                log.fine("roleName: " + roleName);
                            }
                            catch (ConnectException | SocketTimeoutException e) {
                                throw new IllegalStateException("Cannot retrieve the signer object because this is not an EC2 instance and no credentials were provided in the aws.accessKeyId or aws.secretKey system properties.", e);
                            }
                        }
                        String urlContents = InstanceMetadata.getInfoForPath("/latest/meta-data/iam/security-credentials/" + roleName);
                        accessKey = StringUtils.textBetween(urlContents, "\"AccessKeyId\" : \"", "\"").orElseThrow(() -> new RuntimeException("No AccessKeyId: " + urlContents));
                        secretKey = StringUtils.textBetween(urlContents, "\"SecretAccessKey\" : \"", "\"").orElseThrow(() -> new RuntimeException("No SecretAccessKey: " + urlContents));
                        sessionToken = StringUtils.textBetween(urlContents, "\"Token\" : \"", "\"").orElseThrow(() -> new RuntimeException("No Token: " + urlContents));
                        String expiresString = StringUtils.textBetween(urlContents, "\"Expiration\" : \"", "\"").orElseThrow(() -> new RuntimeException("No Expiration: " + urlContents));
                        expires = Signer.parseDateTime(expiresString);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                throw new RuntimeException("Not yet supported to get accessKey and secretKey from roleArn");
                int overlap = 290000;
                cacheExpires = expires.getTime() - (long)overlap;
                log.fine("Auto-lookup of Signer access credentials. AccessKey: " + accessKey + "; secret key is " + secretKey.length() + " characters; sessionToken is " + sessionToken.length() + " characters; expires on " + expires);
            } else {
                cacheExpires = Long.MAX_VALUE;
                log.fine("Signer generated from system properties. AccessKey: " + accessKey);
            }
        }
        cachedSigner = new Signer(accessKey, secretKey, sessionToken);
        return cachedSigner;
    }

    public static Date parseDateTime(String expiresString) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX").parse(expiresString);
        }
        catch (ParseException e) {
            throw new RuntimeException("Could not parse " + expiresString, e);
        }
    }

    public static Date parseDate(String expiresString) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(expiresString);
        }
        catch (ParseException e) {
            throw new RuntimeException("Could not parse " + expiresString, e);
        }
    }

    public Signer assumeRole(String roleArn, String roleSessionName) throws IOException {
        if (roleArn != null && roleSessionName == null || roleArn == null && roleSessionName != null) {
            throw new IllegalArgumentException("roleSessionName and roleArn must both be null, or neither null.");
        }
        AssumeRoleResult assumeRoleResult = new AssumeRole(cachedSigner, roleArn, roleSessionName).call();
        Credentials credentials = assumeRoleResult.getCredentials();
        return new Signer(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken(), this.getDefaultRegion());
    }

    public String getAwsAccountId() throws IOException {
        if (this.awsAccountId == null) {
            try {
                String arn = null;
                try {
                    User user = new GetUserRequest(this, null).call();
                    arn = user.getArn();
                }
                catch (AWSRuntimeException e1) {
                    log.info("Calling GetUser() to retrieve ARN failed, will try parsing from GetRole instead. " + e1.getMessage());
                    try {
                        new GetRoleRequest(this, "_no_such_role_").call();
                    }
                    catch (AccessDeniedException e2) {
                        arn = e2.getMessage().substring(e2.getMessage().indexOf("arn:"));
                        arn = arn.substring(0, arn.indexOf(" "));
                        log.info("Successfully retrieved arn: " + arn);
                    }
                }
                String[] segments = arn.split(":");
                this.awsAccountId = segments[4];
                log.info("awsAccountId is " + this.awsAccountId);
            }
            catch (Exception e) {
                log.info("Could not get AwsAccountId from GetUser API call; will try to read from instance metadata instead. Error message: " + e);
                this.awsAccountId = InstanceMetadata.getAwsAccountNumber();
            }
        }
        return this.awsAccountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signer signer = (Signer)o;
        if (this.sandbox != signer.sandbox) {
            return false;
        }
        if (!this.accessKey.equals(signer.accessKey)) {
            return false;
        }
        if (this.defaultRegion != signer.defaultRegion) {
            return false;
        }
        if (this.productToken != null ? !this.productToken.equals(signer.productToken) : signer.productToken != null) {
            return false;
        }
        if (!this.secretKey.equals(signer.secretKey)) {
            return false;
        }
        if (this.sessionToken != null ? !this.sessionToken.equals(signer.sessionToken) : signer.sessionToken != null) {
            return false;
        }
        return this.userToken != null ? this.userToken.equals(signer.userToken) : signer.userToken == null;
    }

    public int hashCode() {
        int result = this.sessionToken != null ? this.sessionToken.hashCode() : 0;
        result = 31 * result + this.accessKey.hashCode();
        result = 31 * result + this.secretKey.hashCode();
        result = 31 * result + (this.userToken != null ? this.userToken.hashCode() : 0);
        result = 31 * result + (this.productToken != null ? this.productToken.hashCode() : 0);
        result = 31 * result + (this.defaultRegion != null ? this.defaultRegion.hashCode() : 0);
        result = 31 * result + (this.sandbox ? 1 : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessKey";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secretKey";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/prosc/aws/Signer";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/prosc/aws/Signer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecretKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "signRequestV4";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createV4Signature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SigningResult {
        public String credentialScope;
        public String signedHeaders;
        public String signature;
        public String canonicalString;
    }
}

