/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.aws;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.prosc.aws.AwsResult;
import com.prosc.aws.Region;
import com.prosc.aws.ResponseStyle;
import com.prosc.aws.Signer;
import com.prosc.aws.exception.AWSRuntimeException;
import com.prosc.io.AwsUrlEncoder;
import com.prosc.io.IOUtils;
import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AwsRequest<T> {
    private static final Logger log = Logger.getLogger(AwsRequest.class.getName());
    public static final ObjectMapper objectMapper = new ObjectMapper();
    private final Signer signer;
    private boolean retry = true;
    private Region region = null;
    private final Map<String, String> queryParams = new LinkedHashMap<String, String>();
    private final Map<String, String> postParams = new LinkedHashMap<String, String>();
    private final Map<String, Object> jsonParams = new LinkedHashMap<String, Object>();
    private final Map<String, String> requestHeaders = new LinkedHashMap<String, String>();
    private static boolean debugMode = false;
    private int filterCount = 0;
    protected Signer.SigningResult signingResult;

    public AwsRequest(@Nullable Signer signer) {
        this.signer = signer;
    }

    public final T setRegion(Region region) {
        this.region = region;
        return (T)this;
    }

    public final Region getRegion() {
        if (this.region != null) {
            return this.region;
        }
        if (this.signer != null && this.signer.getDefaultRegion() != null) {
            return this.signer.getDefaultRegion();
        }
        return Region.usEast1;
    }

    public Signer.SigningResult getSigningResult() {
        return this.signingResult;
    }

    protected final void setQueryParam(String key, String value) {
        this.queryParams.put(key, value);
    }

    protected final void clearAllParams() {
        this.queryParams.clear();
        this.postParams.clear();
        this.jsonParams.clear();
    }

    protected final Object getParam(String key) {
        if (this.queryParams.containsKey(key)) {
            return this.queryParams.get(key);
        }
        if (this.postParams.containsKey(key)) {
            return this.postParams.get(key);
        }
        return this.jsonParams.get(key);
    }

    protected final void setPostParam(String key, String value) {
        if (this.jsonParams.size() != 0) {
            throw new IllegalArgumentException("setPostParam called with key '" + key + "', but there are existing JSON parameters: " + this.jsonParams.keySet() + ". You cannot combine POST and JSON parameters.");
        }
        this.postParams.put(key, value);
    }

    protected final void setJsonParam(String key, Object value) {
        if (this.postParams.size() != 0) {
            throw new IllegalArgumentException("setJsonParam called with key '" + key + "', but there are existing POST parameters: " + this.postParams.keySet() + ". You cannot combine POST and JSON parameters.");
        }
        this.jsonParams.put(key, value);
    }

    protected final Map<String, Object> getAllParams() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.queryParams.size() + this.postParams.size() + this.jsonParams.size());
        result.putAll(this.queryParams);
        result.putAll(this.postParams);
        result.putAll(this.jsonParams);
        return result;
    }

    public Map<String, String> getQueryParams() {
        return Collections.unmodifiableMap(this.queryParams);
    }

    public Map<String, String> getPostParams() {
        return Collections.unmodifiableMap(this.postParams);
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    protected T setRequestProperty(String key, String value) {
        if (value == null) {
            this.requestHeaders.remove(key);
        } else {
            this.requestHeaders.put(key, value);
        }
        return (T)this;
    }

    public final T setRetry(boolean retry) {
        this.retry = retry;
        return (T)this;
    }

    public final Signer getSigner() {
        return this.signer;
    }

    protected static String encode(String s) {
        return AwsUrlEncoder.encode(s);
    }

    public static void setDebugMode(boolean debugMode) {
        AwsRequest.debugMode = debugMode;
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    protected final AwsResult defaultSend(URL endpoint, String serviceName, ResponseStyle responseStyle, ResponseStyle errorStyle) throws IOException {
        return this.defaultSend(endpoint, -1, serviceName, null, responseStyle, errorStyle, null, null);
    }

    protected final AwsResult defaultSend(URL endpoint, String serviceName, ResponseStyle responseStyle, ResponseStyle errorStyle, @Nullable String contentType) throws IOException {
        return this.defaultSend(endpoint, -1, serviceName, null, responseStyle, errorStyle, null, contentType);
    }

    protected AwsResult defaultSend(URL endpoint, int connectTimeoutMilliseconds, String serviceName, @Nullable String method, ResponseStyle responseStyle, ResponseStyle errorStyle, @Nullable byte[] payload, @Nullable String contentType) throws IOException, AWSRuntimeException {
        if (this.postParams.isEmpty() && this.jsonParams.isEmpty()) {
            if (method == null) {
                method = "GET";
            }
        } else if (this.jsonParams.isEmpty()) {
            if (method == null) {
                method = "POST";
            }
            if (payload == null) {
                payload = IOUtils.urlEncodeMap(this.postParams).getBytes(StandardCharsets.UTF_8);
            }
        } else if (this.postParams.isEmpty()) {
            if (method == null) {
                method = "POST";
            }
            if (payload == null) {
                payload = this.convertJsonToString().getBytes(StandardCharsets.UTF_8);
            }
            if (contentType == null) {
                contentType = "application/json";
            }
        } else {
            throw new IllegalStateException("You cannot set both postParams and jsonParams, pick one or the other");
        }
        if (!this.queryParams.isEmpty()) {
            String query = AwsRequest.urlEncodeMap(this.queryParams);
            endpoint = new URL(endpoint.getProtocol(), endpoint.getHost(), endpoint.getPort(), endpoint.getPath() + "?" + query);
        }
        HttpURLConnection connection = (HttpURLConnection)endpoint.openConnection();
        connection.setUseCaches(false);
        connection.setRequestMethod(method);
        if (connectTimeoutMilliseconds != -1) {
            connection.setConnectTimeout(connectTimeoutMilliseconds);
        }
        for (Map.Entry<String, String> entry : this.requestHeaders.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (this.getSigner() == null) {
            log.config("Signer is null, so request will not be signed. This is valid for some services like SNS.");
        } else {
            this.getSigner().signRequestV4(connection, this.getRegion(), serviceName, this, payload);
        }
        if ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) {
            connection.setDoOutput(true);
            int payloadLength = payload == null ? 0 : payload.length;
            connection.setFixedLengthStreamingMode(payloadLength);
            if (contentType != null) {
                connection.setRequestProperty("content-type", contentType);
            }
            if (payload != null) {
                try (OutputStream outputStream = connection.getOutputStream();){
                    outputStream.write(payload);
                    if (debugMode) {
                        log.info("defaultSend for " + this.getClass().getName() + " payload:\n" + StringUtils.truncate(new String(payload, StandardCharsets.UTF_8), 8192));
                    }
                }
            }
        }
        return new AwsResult(connection, responseStyle, errorStyle, this).download();
    }

    private String convertJsonToString() throws IOException {
        try (StringWriter sw = new StringWriter();){
            objectMapper.writeValue(sw, this.jsonParams);
            String string = sw.toString();
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    protected final AwsResult sendWithRetry(@Nullable ReentrantReadWriteLock throttlingLock, String nextToken) throws IOException, AWSRuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Nonsensical loop would be emitted - failure
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopIdentifier.considerAsDoLoopStart(LoopIdentifier.java:438)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopIdentifier.identifyLoops1(LoopIdentifier.java:65)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:681)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final AwsResult sendWithRetry() throws IOException {
        return this.sendWithRetry(null, null);
    }

    protected final AwsResult sendWithRetry(String nextToken) throws IOException {
        return this.sendWithRetry(null, nextToken);
    }

    protected abstract AwsResult _send(@Nullable String var1) throws IOException, AWSRuntimeException;

    protected static String urlEncodeMap(Map<String, ?> dict) {
        StringBuilder urlString = new StringBuilder();
        Iterator<String> iterator = dict.keySet().iterator();
        while (iterator.hasNext()) {
            String aKey = iterator.next();
            Object anObject = dict.get(aKey);
            aKey = AwsRequest.encode(aKey);
            if (anObject instanceof List) {
                Iterator en = ((List)anObject).iterator();
                while (en.hasNext()) {
                    String nextElement = (String)en.next();
                    urlString.append(aKey).append("=").append(AwsRequest.encode(nextElement));
                    if (!en.hasNext()) continue;
                    urlString.append("&");
                }
            } else {
                if (anObject == null) {
                    anObject = "";
                }
                urlString.append(aKey).append("=").append(AwsRequest.encode((String)anObject));
            }
            if (!iterator.hasNext()) continue;
            urlString.append("&");
        }
        return urlString.toString();
    }

    @NotNull
    protected T addFilter(String key, List<String> values) {
        int index = ++this.filterCount;
        this.setQueryParam("Filter." + index + ".Name", key);
        int valueIndex = 0;
        for (String value : values) {
            this.setQueryParam("Filter." + index + ".Value." + ++valueIndex, value);
        }
        AwsRequest awsRequest = this;
        if (awsRequest == null) {
            AwsRequest.$$$reportNull$$$0(0);
        }
        return (T)awsRequest;
    }

    protected final String getParamDescriptionTruncated() {
        String result = this.getAllParams().toString();
        if (result.length() > 255) {
            result = result.substring(0, 255);
        }
        return result;
    }

    public String toString() {
        return "AwsRequest{class=" + this.getClass() + ", params=" + this.getParamDescriptionTruncated() + '}';
    }

    public void setSigningResult(Signer.SigningResult signingResult) {
        this.signingResult = signingResult;
    }

    private /* synthetic */ AwsResult lambda$sendWithRetry$0(String nextToken, int whichAttempt, int maxAttempts) throws Exception {
        return this._send(nextToken);
    }

    static {
        if (Boolean.getBoolean("com.prosc.aws.debug")) {
            AwsRequest.setDebugMode(true);
        }
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/prosc/aws/AwsRequest", "addFilter"));
    }
}

