/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutAttributesRequestMarshaller
implements Marshaller<Request<PutAttributesRequest>, PutAttributesRequest> {
    @Override
    public Request<PutAttributesRequest> marshall(PutAttributesRequest putAttributesRequest) {
        UpdateCondition expected;
        if (putAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutAttributesRequest> request = new DefaultRequest<PutAttributesRequest>(putAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "PutAttributes");
        request.addParameter("Version", "2009-04-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (putAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(putAttributesRequest.getDomainName()));
        }
        if (putAttributesRequest.getItemName() != null) {
            request.addParameter("ItemName", StringUtils.fromString(putAttributesRequest.getItemName()));
        }
        if (!putAttributesRequest.getAttributes().isEmpty() || !((SdkInternalList)putAttributesRequest.getAttributes()).isAutoConstruct()) {
            SdkInternalList attributesList = (SdkInternalList)putAttributesRequest.getAttributes();
            int attributesListIndex = 1;
            for (ReplaceableAttribute attributesListValue : attributesList) {
                if (attributesListValue != null) {
                    if (attributesListValue.getName() != null) {
                        request.addParameter("Attribute." + attributesListIndex + ".Name", StringUtils.fromString(attributesListValue.getName()));
                    }
                    if (attributesListValue.getValue() != null) {
                        request.addParameter("Attribute." + attributesListIndex + ".Value", StringUtils.fromString(attributesListValue.getValue()));
                    }
                    if (attributesListValue.getReplace() != null) {
                        request.addParameter("Attribute." + attributesListIndex + ".Replace", StringUtils.fromBoolean(attributesListValue.getReplace()));
                    }
                }
                ++attributesListIndex;
            }
        }
        if ((expected = putAttributesRequest.getExpected()) != null) {
            if (expected.getName() != null) {
                request.addParameter("Expected.Name", StringUtils.fromString(expected.getName()));
            }
            if (expected.getValue() != null) {
                request.addParameter("Expected.Value", StringUtils.fromString(expected.getValue()));
            }
            if (expected.getExists() != null) {
                request.addParameter("Expected.Exists", StringUtils.fromBoolean(expected.getExists()));
            }
        }
        return request;
    }
}

