/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteAttributesRequestMarshaller
implements Marshaller<Request<DeleteAttributesRequest>, DeleteAttributesRequest> {
    @Override
    public Request<DeleteAttributesRequest> marshall(DeleteAttributesRequest deleteAttributesRequest) {
        UpdateCondition expected;
        if (deleteAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteAttributesRequest> request = new DefaultRequest<DeleteAttributesRequest>(deleteAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "DeleteAttributes");
        request.addParameter("Version", "2009-04-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(deleteAttributesRequest.getDomainName()));
        }
        if (deleteAttributesRequest.getItemName() != null) {
            request.addParameter("ItemName", StringUtils.fromString(deleteAttributesRequest.getItemName()));
        }
        if (!deleteAttributesRequest.getAttributes().isEmpty() || !((SdkInternalList)deleteAttributesRequest.getAttributes()).isAutoConstruct()) {
            SdkInternalList attributesList = (SdkInternalList)deleteAttributesRequest.getAttributes();
            int attributesListIndex = 1;
            for (Attribute attributesListValue : attributesList) {
                if (attributesListValue != null) {
                    if (attributesListValue.getName() != null) {
                        request.addParameter("Attribute." + attributesListIndex + ".Name", StringUtils.fromString(attributesListValue.getName()));
                    }
                    if (attributesListValue.getAlternateNameEncoding() != null) {
                        request.addParameter("Attribute." + attributesListIndex + ".AlternateNameEncoding", StringUtils.fromString(attributesListValue.getAlternateNameEncoding()));
                    }
                    if (attributesListValue.getValue() != null) {
                        request.addParameter("Attribute." + attributesListIndex + ".Value", StringUtils.fromString(attributesListValue.getValue()));
                    }
                    if (attributesListValue.getAlternateValueEncoding() != null) {
                        request.addParameter("Attribute." + attributesListIndex + ".AlternateValueEncoding", StringUtils.fromString(attributesListValue.getAlternateValueEncoding()));
                    }
                }
                ++attributesListIndex;
            }
        }
        if ((expected = deleteAttributesRequest.getExpected()) != null) {
            if (expected.getName() != null) {
                request.addParameter("Expected.Name", StringUtils.fromString(expected.getName()));
            }
            if (expected.getValue() != null) {
                request.addParameter("Expected.Value", StringUtils.fromString(expected.getValue()));
            }
            if (expected.getExists() != null) {
                request.addParameter("Expected.Exists", StringUtils.fromBoolean(expected.getExists()));
            }
        }
        return request;
    }
}

