/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.DeletableItem;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class BatchDeleteAttributesRequestMarshaller
implements Marshaller<Request<BatchDeleteAttributesRequest>, BatchDeleteAttributesRequest> {
    @Override
    public Request<BatchDeleteAttributesRequest> marshall(BatchDeleteAttributesRequest batchDeleteAttributesRequest) {
        if (batchDeleteAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchDeleteAttributesRequest> request = new DefaultRequest<BatchDeleteAttributesRequest>(batchDeleteAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "BatchDeleteAttributes");
        request.addParameter("Version", "2009-04-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (batchDeleteAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(batchDeleteAttributesRequest.getDomainName()));
        }
        if (!batchDeleteAttributesRequest.getItems().isEmpty() || !((SdkInternalList)batchDeleteAttributesRequest.getItems()).isAutoConstruct()) {
            SdkInternalList itemsList = (SdkInternalList)batchDeleteAttributesRequest.getItems();
            int itemsListIndex = 1;
            for (DeletableItem itemsListValue : itemsList) {
                if (itemsListValue != null) {
                    if (itemsListValue.getName() != null) {
                        request.addParameter("Item." + itemsListIndex + ".ItemName", StringUtils.fromString(itemsListValue.getName()));
                    }
                    if (!itemsListValue.getAttributes().isEmpty() || !((SdkInternalList)itemsListValue.getAttributes()).isAutoConstruct()) {
                        SdkInternalList attributesList = (SdkInternalList)itemsListValue.getAttributes();
                        int attributesListIndex = 1;
                        for (Attribute attributesListValue : attributesList) {
                            if (attributesListValue != null) {
                                if (attributesListValue.getName() != null) {
                                    request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Name", StringUtils.fromString(attributesListValue.getName()));
                                }
                                if (attributesListValue.getAlternateNameEncoding() != null) {
                                    request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".AlternateNameEncoding", StringUtils.fromString(attributesListValue.getAlternateNameEncoding()));
                                }
                                if (attributesListValue.getValue() != null) {
                                    request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Value", StringUtils.fromString(attributesListValue.getValue()));
                                }
                                if (attributesListValue.getAlternateValueEncoding() != null) {
                                    request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".AlternateValueEncoding", StringUtils.fromString(attributesListValue.getAlternateValueEncoding()));
                                }
                            }
                            ++attributesListIndex;
                        }
                    }
                }
                ++itemsListIndex;
            }
        }
        return request;
    }
}

