/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class Sequencer {
    private static final Logger log = Logger.getLogger(Sequencer.class.getName());
    private LinkedHashMap<Object, TaskEntry> triggers = new LinkedHashMap();
    private Thread triggerThread = null;

    public synchronized void appendNew(Object key, long date, Runnable task) {
        TaskEntry entry = new TaskEntry(date, task);
        boolean didAdd = this.triggers.put(key, entry) == null;
        this.triggersChanged(didAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void appendExisting(Object key, long date) {
        Sequencer sequencer = this;
        synchronized (sequencer) {
            TaskEntry entry = (TaskEntry)this.triggers.remove(key);
            if (entry == null) {
                throw new IllegalArgumentException("No task exists for key " + key);
            }
            boolean didAdd = this.triggers.put(key, new TaskEntry(date, entry.task)) == null;
            this.triggersChanged(didAdd);
        }
    }

    public synchronized void remove(Object key) {
        this.triggers.remove(key);
        this.triggersChanged(false);
    }

    public synchronized void clear() {
        this.triggers.clear();
        this.triggersChanged(false);
    }

    private synchronized void triggersChanged(boolean didAdd) {
        if (didAdd && (this.triggerThread == null || !this.triggerThread.isAlive())) {
            this.triggerThread = new Thread("Prosc Sequencer thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Sequencer sequencer = Sequencer.this;
                        synchronized (sequencer) {
                            while (Sequencer.this.triggers.size() != 0) {
                                Map.Entry next = Sequencer.this.triggers.entrySet().iterator().next();
                                TaskEntry nextTask = (TaskEntry)next.getValue();
                                long delay = nextTask.date - System.currentTimeMillis();
                                if (delay <= 0L) {
                                    nextTask.task.run();
                                    Sequencer.this.triggers.remove(next.getKey());
                                    continue;
                                }
                                Sequencer.this.wait(delay);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.info(this.getName() + " was interrupted; exiting loop");
                    }
                }
            };
            this.triggerThread.start();
        } else {
            this.notifyAll();
        }
    }

    private static class TaskEntry
    implements Comparable<TaskEntry> {
        final long date;
        final Runnable task;

        private TaskEntry(long date, Runnable task) {
            this.date = date;
            this.task = task;
        }

        @Override
        public int compareTo(TaskEntry o) {
            return Long.compare(this.date, o.date);
        }
    }
}

