/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.shared;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class diff_match_patch {
    public float Diff_Timeout = 1.0f;
    public short Diff_EditCost = (short)4;
    public short Diff_DualThreshold = (short)32;
    public float Match_Threshold = 0.5f;
    public int Match_Distance = 1000;
    public float Patch_DeleteThreshold = 0.5f;
    public short Patch_Margin = (short)4;
    private int Match_MaxBits = 32;
    private Pattern BLANKLINEEND = Pattern.compile("\\n\\r?\\n\\Z", 32);
    private Pattern BLANKLINESTART = Pattern.compile("\\A\\r?\\n\\r?\\n", 32);

    public LinkedList<Diff> diff_main(String text1, String text2) {
        return this.diff_main(text1, text2, true);
    }

    public LinkedList<Diff> diff_main(String text1, String text2, boolean checklines) {
        if (text1.equals(text2)) {
            LinkedList<Diff> diffs = new LinkedList<Diff>();
            diffs.add(new Diff(Operation.EQUAL, text1));
            return diffs;
        }
        int commonlength = this.diff_commonPrefix(text1, text2);
        String commonprefix = text1.substring(0, commonlength);
        text1 = text1.substring(commonlength);
        text2 = text2.substring(commonlength);
        commonlength = this.diff_commonSuffix(text1, text2);
        String commonsuffix = text1.substring(text1.length() - commonlength);
        text1 = text1.substring(0, text1.length() - commonlength);
        text2 = text2.substring(0, text2.length() - commonlength);
        LinkedList<Diff> diffs = this.diff_compute(text1, text2, checklines);
        if (commonprefix.length() != 0) {
            diffs.addFirst(new Diff(Operation.EQUAL, commonprefix));
        }
        if (commonsuffix.length() != 0) {
            diffs.addLast(new Diff(Operation.EQUAL, commonsuffix));
        }
        this.diff_cleanupMerge(diffs);
        return diffs;
    }

    protected LinkedList<Diff> diff_compute(String text1, String text2, boolean checklines) {
        String shorttext;
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        if (text1.length() == 0) {
            diffs.add(new Diff(Operation.INSERT, text2));
            return diffs;
        }
        if (text2.length() == 0) {
            diffs.add(new Diff(Operation.DELETE, text1));
            return diffs;
        }
        String longtext = text1.length() > text2.length() ? text1 : text2;
        int i = longtext.indexOf(shorttext = text1.length() > text2.length() ? text2 : text1);
        if (i != -1) {
            Operation op = text1.length() > text2.length() ? Operation.DELETE : Operation.INSERT;
            diffs.add(new Diff(op, longtext.substring(0, i)));
            diffs.add(new Diff(Operation.EQUAL, shorttext));
            diffs.add(new Diff(op, longtext.substring(i + shorttext.length())));
            return diffs;
        }
        shorttext = null;
        longtext = null;
        String[] hm = this.diff_halfMatch(text1, text2);
        if (hm != null) {
            String text1_a = hm[0];
            String text1_b = hm[1];
            String text2_a = hm[2];
            String text2_b = hm[3];
            String mid_common = hm[4];
            LinkedList<Diff> diffs_a = this.diff_main(text1_a, text2_a, checklines);
            LinkedList<Diff> diffs_b = this.diff_main(text1_b, text2_b, checklines);
            diffs = diffs_a;
            diffs.add(new Diff(Operation.EQUAL, mid_common));
            diffs.addAll(diffs_b);
            return diffs;
        }
        if (checklines && (text1.length() < 100 || text2.length() < 100)) {
            checklines = false;
        }
        List<String> linearray = null;
        if (checklines) {
            LinesToCharsResult b = this.diff_linesToChars(text1, text2);
            text1 = b.chars1;
            text2 = b.chars2;
            linearray = b.lineArray;
        }
        if ((diffs = this.diff_map(text1, text2)) == null) {
            diffs = new LinkedList();
            diffs.add(new Diff(Operation.DELETE, text1));
            diffs.add(new Diff(Operation.INSERT, text2));
        }
        if (checklines) {
            this.diff_charsToLines(diffs, linearray);
            this.diff_cleanupSemantic(diffs);
            diffs.add(new Diff(Operation.EQUAL, ""));
            int count_delete = 0;
            int count_insert = 0;
            String text_delete = "";
            String text_insert = "";
            ListIterator<Diff> pointer = diffs.listIterator();
            Diff thisDiff = (Diff)pointer.next();
            while (thisDiff != null) {
                switch (thisDiff.operation) {
                    case INSERT: {
                        ++count_insert;
                        text_insert = text_insert + thisDiff.text;
                        break;
                    }
                    case DELETE: {
                        ++count_delete;
                        text_delete = text_delete + thisDiff.text;
                        break;
                    }
                    case EQUAL: {
                        if (count_delete >= 1 && count_insert >= 1) {
                            pointer.previous();
                            for (int j = 0; j < count_delete + count_insert; ++j) {
                                pointer.previous();
                                pointer.remove();
                            }
                            for (Diff newDiff : this.diff_main(text_delete, text_insert, false)) {
                                pointer.add(newDiff);
                            }
                        }
                        count_insert = 0;
                        count_delete = 0;
                        text_delete = "";
                        text_insert = "";
                    }
                }
                thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
            }
            diffs.removeLast();
        }
        return diffs;
    }

    protected LinesToCharsResult diff_linesToChars(String text1, String text2) {
        ArrayList<String> lineArray = new ArrayList<String>();
        HashMap<String, Integer> lineHash = new HashMap<String, Integer>();
        lineArray.add("");
        String chars1 = this.diff_linesToCharsMunge(text1, lineArray, lineHash);
        String chars2 = this.diff_linesToCharsMunge(text2, lineArray, lineHash);
        return new LinesToCharsResult(chars1, chars2, lineArray);
    }

    private String diff_linesToCharsMunge(String text, List<String> lineArray, Map<String, Integer> lineHash) {
        int lineStart = 0;
        int lineEnd = -1;
        StringBuilder chars = new StringBuilder();
        while (lineEnd < text.length() - 1) {
            lineEnd = text.indexOf(10, lineStart);
            if (lineEnd == -1) {
                lineEnd = text.length() - 1;
            }
            String line = text.substring(lineStart, lineEnd + 1);
            lineStart = lineEnd + 1;
            if (lineHash.containsKey(line)) {
                chars.append(String.valueOf((char)lineHash.get(line).intValue()));
                continue;
            }
            lineArray.add(line);
            lineHash.put(line, lineArray.size() - 1);
            chars.append(String.valueOf((char)(lineArray.size() - 1)));
        }
        return chars.toString();
    }

    protected void diff_charsToLines(LinkedList<Diff> diffs, List<String> lineArray) {
        for (Diff diff : diffs) {
            StringBuilder text = new StringBuilder();
            for (int y = 0; y < diff.text.length(); ++y) {
                text.append(lineArray.get(diff.text.charAt(y)));
            }
            diff.text = text.toString();
        }
    }

    protected LinkedList<Diff> diff_map(String text1, String text2) {
        int text2_length;
        long ms_end = System.currentTimeMillis() + (long)(this.Diff_Timeout * 1000.0f);
        int text1_length = text1.length();
        int max_d = text1_length + (text2_length = text2.length()) - 1;
        boolean doubleEnd = this.Diff_DualThreshold * 2 < max_d;
        List<Set<Long>> v_map1 = new ArrayList<Set<Long>>();
        List<Set<Long>> v_map2 = new ArrayList();
        HashMap<Integer, Integer> v1 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> v2 = new HashMap<Integer, Integer>();
        v1.put(1, 0);
        v2.put(1, 0);
        Long footstep = 0L;
        HashMap<Long, Integer> footsteps = new HashMap<Long, Integer>();
        boolean done = false;
        boolean front = (text1_length + text2_length) % 2 == 1;
        for (int d = 0; d < max_d; ++d) {
            int y;
            int x;
            int k;
            if (this.Diff_Timeout > 0.0f && System.currentTimeMillis() > ms_end) {
                return null;
            }
            v_map1.add(new HashSet());
            for (k = -d; k <= d; k += 2) {
                x = k == -d || k != d && (Integer)v1.get(k - 1) < (Integer)v1.get(k + 1) ? (Integer)v1.get(k + 1) : (Integer)v1.get(k - 1) + 1;
                y = x - k;
                if (doubleEnd) {
                    footstep = this.diff_footprint(x, y);
                    if (front && footsteps.containsKey(footstep)) {
                        done = true;
                    }
                    if (!front) {
                        footsteps.put(footstep, d);
                    }
                }
                while (!done && x < text1_length && y < text2_length && text1.charAt(x) == text2.charAt(y)) {
                    ++x;
                    ++y;
                    if (!doubleEnd) continue;
                    footstep = this.diff_footprint(x, y);
                    if (front && footsteps.containsKey(footstep)) {
                        done = true;
                    }
                    if (front) continue;
                    footsteps.put(footstep, d);
                }
                v1.put(k, x);
                ((Set)v_map1.get(d)).add(this.diff_footprint(x, y));
                if (x == text1_length && y == text2_length) {
                    return this.diff_path1(v_map1, text1, text2);
                }
                if (!done) continue;
                v_map2 = v_map2.subList(0, (Integer)footsteps.get(footstep) + 1);
                LinkedList<Diff> a = this.diff_path1(v_map1, text1.substring(0, x), text2.substring(0, y));
                a.addAll(this.diff_path2(v_map2, text1.substring(x), text2.substring(y)));
                return a;
            }
            if (!doubleEnd) continue;
            v_map2.add(new HashSet());
            for (k = -d; k <= d; k += 2) {
                x = k == -d || k != d && (Integer)v2.get(k - 1) < (Integer)v2.get(k + 1) ? (Integer)v2.get(k + 1) : (Integer)v2.get(k - 1) + 1;
                y = x - k;
                footstep = this.diff_footprint(text1_length - x, text2_length - y);
                if (!front && footsteps.containsKey(footstep)) {
                    done = true;
                }
                if (front) {
                    footsteps.put(footstep, d);
                }
                while (!done && x < text1_length && y < text2_length && text1.charAt(text1_length - x - 1) == text2.charAt(text2_length - y - 1)) {
                    footstep = this.diff_footprint(text1_length - ++x, text2_length - ++y);
                    if (!front && footsteps.containsKey(footstep)) {
                        done = true;
                    }
                    if (!front) continue;
                    footsteps.put(footstep, d);
                }
                v2.put(k, x);
                ((Set)v_map2.get(d)).add(this.diff_footprint(x, y));
                if (!done) continue;
                v_map1 = v_map1.subList(0, (Integer)footsteps.get(footstep) + 1);
                LinkedList<Diff> a = this.diff_path1(v_map1, text1.substring(0, text1_length - x), text2.substring(0, text2_length - y));
                a.addAll(this.diff_path2(v_map2, text1.substring(text1_length - x), text2.substring(text2_length - y)));
                return a;
            }
        }
        return null;
    }

    protected LinkedList<Diff> diff_path1(List<Set<Long>> v_map, String text1, String text2) {
        LinkedList<Diff> path = new LinkedList<Diff>();
        int x = text1.length();
        int y = text2.length();
        Operation last_op = null;
        block0: for (int d = v_map.size() - 2; d >= 0; --d) {
            while (true) {
                if (v_map.get(d).contains(this.diff_footprint(x - 1, y))) {
                    --x;
                    if (last_op == Operation.DELETE) {
                        path.getFirst().text = text1.charAt(x) + path.getFirst().text;
                    } else {
                        path.addFirst(new Diff(Operation.DELETE, text1.substring(x, x + 1)));
                    }
                    last_op = Operation.DELETE;
                    continue block0;
                }
                if (v_map.get(d).contains(this.diff_footprint(x, y - 1))) {
                    --y;
                    if (last_op == Operation.INSERT) {
                        path.getFirst().text = text2.charAt(y) + path.getFirst().text;
                    } else {
                        path.addFirst(new Diff(Operation.INSERT, text2.substring(y, y + 1)));
                    }
                    last_op = Operation.INSERT;
                    continue block0;
                }
                assert (text1.charAt(--x) == text2.charAt(--y)) : "No diagonal.  Can't happen. (diff_path1)";
                if (last_op == Operation.EQUAL) {
                    path.getFirst().text = text1.charAt(x) + path.getFirst().text;
                } else {
                    path.addFirst(new Diff(Operation.EQUAL, text1.substring(x, x + 1)));
                }
                last_op = Operation.EQUAL;
            }
        }
        return path;
    }

    protected LinkedList<Diff> diff_path2(List<Set<Long>> v_map, String text1, String text2) {
        LinkedList<Diff> path = new LinkedList<Diff>();
        int x = text1.length();
        int y = text2.length();
        Operation last_op = null;
        block0: for (int d = v_map.size() - 2; d >= 0; --d) {
            while (true) {
                if (v_map.get(d).contains(this.diff_footprint(x - 1, y))) {
                    --x;
                    if (last_op == Operation.DELETE) {
                        path.getLast().text = path.getLast().text + text1.charAt(text1.length() - x - 1);
                    } else {
                        path.addLast(new Diff(Operation.DELETE, text1.substring(text1.length() - x - 1, text1.length() - x)));
                    }
                    last_op = Operation.DELETE;
                    continue block0;
                }
                if (v_map.get(d).contains(this.diff_footprint(x, y - 1))) {
                    --y;
                    if (last_op == Operation.INSERT) {
                        path.getLast().text = path.getLast().text + text2.charAt(text2.length() - y - 1);
                    } else {
                        path.addLast(new Diff(Operation.INSERT, text2.substring(text2.length() - y - 1, text2.length() - y)));
                    }
                    last_op = Operation.INSERT;
                    continue block0;
                }
                assert (text1.charAt(text1.length() - --x - 1) == text2.charAt(text2.length() - --y - 1)) : "No diagonal.  Can't happen. (diff_path2)";
                if (last_op == Operation.EQUAL) {
                    path.getLast().text = path.getLast().text + text1.charAt(text1.length() - x - 1);
                } else {
                    path.addLast(new Diff(Operation.EQUAL, text1.substring(text1.length() - x - 1, text1.length() - x)));
                }
                last_op = Operation.EQUAL;
            }
        }
        return path;
    }

    protected long diff_footprint(int x, int y) {
        long result = x;
        result <<= 32;
        return result += (long)y;
    }

    public int diff_commonPrefix(String text1, String text2) {
        int n = Math.min(text1.length(), text2.length());
        for (int i = 0; i < n; ++i) {
            if (text1.charAt(i) == text2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    public int diff_commonSuffix(String text1, String text2) {
        int text1_length = text1.length();
        int text2_length = text2.length();
        int n = Math.min(text1_length, text2_length);
        for (int i = 1; i <= n; ++i) {
            if (text1.charAt(text1_length - i) == text2.charAt(text2_length - i)) continue;
            return i - 1;
        }
        return n;
    }

    protected String[] diff_halfMatch(String text1, String text2) {
        String[] hm;
        String shorttext;
        String longtext = text1.length() > text2.length() ? text1 : text2;
        String string = shorttext = text1.length() > text2.length() ? text2 : text1;
        if (longtext.length() < 10 || shorttext.length() < 1) {
            return null;
        }
        String[] hm1 = this.diff_halfMatchI(longtext, shorttext, (longtext.length() + 3) / 4);
        String[] hm2 = this.diff_halfMatchI(longtext, shorttext, (longtext.length() + 1) / 2);
        if (hm1 == null && hm2 == null) {
            return null;
        }
        if (hm2 == null) {
            hm = hm1;
        } else if (hm1 == null) {
            hm = hm2;
        } else {
            String[] stringArray = hm = hm1[4].length() > hm2[4].length() ? hm1 : hm2;
        }
        if (text1.length() > text2.length()) {
            return hm;
        }
        return new String[]{hm[2], hm[3], hm[0], hm[1], hm[4]};
    }

    private String[] diff_halfMatchI(String longtext, String shorttext, int i) {
        String seed = longtext.substring(i, i + longtext.length() / 4);
        int j = -1;
        String best_common = "";
        String best_longtext_a = "";
        String best_longtext_b = "";
        String best_shorttext_a = "";
        String best_shorttext_b = "";
        while ((j = shorttext.indexOf(seed, j + 1)) != -1) {
            int prefixLength = this.diff_commonPrefix(longtext.substring(i), shorttext.substring(j));
            int suffixLength = this.diff_commonSuffix(longtext.substring(0, i), shorttext.substring(0, j));
            if (best_common.length() >= suffixLength + prefixLength) continue;
            best_common = shorttext.substring(j - suffixLength, j) + shorttext.substring(j, j + prefixLength);
            best_longtext_a = longtext.substring(0, i - suffixLength);
            best_longtext_b = longtext.substring(i + prefixLength);
            best_shorttext_a = shorttext.substring(0, j - suffixLength);
            best_shorttext_b = shorttext.substring(j + prefixLength);
        }
        if (best_common.length() >= longtext.length() / 2) {
            return new String[]{best_longtext_a, best_longtext_b, best_shorttext_a, best_shorttext_b, best_common};
        }
        return null;
    }

    public void diff_cleanupSemantic(LinkedList<Diff> diffs) {
        if (diffs.isEmpty()) {
            return;
        }
        boolean changes = false;
        Stack<Diff> equalities = new Stack<Diff>();
        String lastequality = null;
        ListIterator<Diff> pointer = diffs.listIterator();
        int length_changes1 = 0;
        int length_changes2 = 0;
        Diff thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            if (thisDiff.operation == Operation.EQUAL) {
                equalities.push(thisDiff);
                length_changes1 = length_changes2;
                length_changes2 = 0;
                lastequality = thisDiff.text;
            } else if (lastequality != null && lastequality.length() <= length_changes1 && lastequality.length() <= (length_changes2 += thisDiff.text.length())) {
                while (thisDiff != equalities.lastElement()) {
                    thisDiff = (Diff)pointer.previous();
                }
                pointer.next();
                pointer.set(new Diff(Operation.DELETE, lastequality));
                pointer.add(new Diff(Operation.INSERT, lastequality));
                equalities.pop();
                if (!equalities.empty()) {
                    equalities.pop();
                }
                if (equalities.empty()) {
                    while (pointer.hasPrevious()) {
                        pointer.previous();
                    }
                } else {
                    thisDiff = (Diff)equalities.lastElement();
                    while (thisDiff != pointer.previous()) {
                    }
                }
                length_changes1 = 0;
                length_changes2 = 0;
                lastequality = null;
                changes = true;
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diff_cleanupMerge(diffs);
        }
        this.diff_cleanupSemanticLossless(diffs);
    }

    public void diff_cleanupSemanticLossless(LinkedList<Diff> diffs) {
        Diff nextDiff;
        ListIterator pointer = diffs.listIterator();
        Diff prevDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff diff = nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        while (nextDiff != null) {
            if (prevDiff.operation == Operation.EQUAL && nextDiff.operation == Operation.EQUAL) {
                String equality1 = prevDiff.text;
                String edit = thisDiff.text;
                String equality2 = nextDiff.text;
                int commonOffset = this.diff_commonSuffix(equality1, edit);
                if (commonOffset != 0) {
                    String commonString = edit.substring(edit.length() - commonOffset);
                    equality1 = equality1.substring(0, equality1.length() - commonOffset);
                    edit = commonString + edit.substring(0, edit.length() - commonOffset);
                    equality2 = commonString + equality2;
                }
                String bestEquality1 = equality1;
                String bestEdit = edit;
                String bestEquality2 = equality2;
                int bestScore = this.diff_cleanupSemanticScore(equality1, edit) + this.diff_cleanupSemanticScore(edit, equality2);
                while (edit.length() != 0 && equality2.length() != 0 && edit.charAt(0) == equality2.charAt(0)) {
                    equality1 = equality1 + edit.charAt(0);
                    edit = edit.substring(1) + equality2.charAt(0);
                    equality2 = equality2.substring(1);
                    int score = this.diff_cleanupSemanticScore(equality1, edit) + this.diff_cleanupSemanticScore(edit, equality2);
                    if (score < bestScore) continue;
                    bestScore = score;
                    bestEquality1 = equality1;
                    bestEdit = edit;
                    bestEquality2 = equality2;
                }
                if (!prevDiff.text.equals(bestEquality1)) {
                    if (bestEquality1.length() != 0) {
                        prevDiff.text = bestEquality1;
                    } else {
                        pointer.previous();
                        pointer.previous();
                        pointer.previous();
                        pointer.remove();
                        pointer.next();
                        pointer.next();
                    }
                    thisDiff.text = bestEdit;
                    if (bestEquality2.length() != 0) {
                        nextDiff.text = bestEquality2;
                    } else {
                        pointer.remove();
                        nextDiff = thisDiff;
                        thisDiff = prevDiff;
                    }
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
    }

    private int diff_cleanupSemanticScore(String one, String two) {
        if (one.length() == 0 || two.length() == 0) {
            return 5;
        }
        int score = 0;
        if (!Character.isLetterOrDigit(one.charAt(one.length() - 1)) || !Character.isLetterOrDigit(two.charAt(0))) {
            ++score;
            if (Character.isWhitespace(one.charAt(one.length() - 1)) || Character.isWhitespace(two.charAt(0))) {
                ++score;
                if (Character.getType(one.charAt(one.length() - 1)) == 15 || Character.getType(two.charAt(0)) == 15) {
                    ++score;
                    if (this.BLANKLINEEND.matcher(one).find() || this.BLANKLINESTART.matcher(two).find()) {
                        ++score;
                    }
                }
            }
        }
        return score;
    }

    public void diff_cleanupEfficiency(LinkedList<Diff> diffs) {
        Diff thisDiff;
        if (diffs.isEmpty()) {
            return;
        }
        boolean changes = false;
        Stack<Diff> equalities = new Stack<Diff>();
        String lastequality = null;
        ListIterator<Diff> pointer = diffs.listIterator();
        boolean pre_ins = false;
        boolean pre_del = false;
        boolean post_ins = false;
        boolean post_del = false;
        Diff safeDiff = thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            if (thisDiff.operation == Operation.EQUAL) {
                if (thisDiff.text.length() < this.Diff_EditCost && (post_ins || post_del)) {
                    equalities.push(thisDiff);
                    pre_ins = post_ins;
                    pre_del = post_del;
                    lastequality = thisDiff.text;
                } else {
                    equalities.clear();
                    lastequality = null;
                    safeDiff = thisDiff;
                }
                post_del = false;
                post_ins = false;
            } else {
                if (thisDiff.operation == Operation.DELETE) {
                    post_del = true;
                } else {
                    post_ins = true;
                }
                if (lastequality != null && (pre_ins && pre_del && post_ins && post_del || lastequality.length() < this.Diff_EditCost / 2 && (pre_ins ? 1 : 0) + (pre_del ? 1 : 0) + (post_ins ? 1 : 0) + (post_del ? 1 : 0) == 3)) {
                    while (thisDiff != equalities.lastElement()) {
                        thisDiff = (Diff)pointer.previous();
                    }
                    pointer.next();
                    pointer.set(new Diff(Operation.DELETE, lastequality));
                    thisDiff = new Diff(Operation.INSERT, lastequality);
                    pointer.add(thisDiff);
                    equalities.pop();
                    lastequality = null;
                    if (pre_ins && pre_del) {
                        post_del = true;
                        post_ins = true;
                        equalities.clear();
                        safeDiff = thisDiff;
                    } else {
                        if (!equalities.empty()) {
                            equalities.pop();
                        }
                        thisDiff = equalities.empty() ? safeDiff : (Diff)equalities.lastElement();
                        while (thisDiff != pointer.previous()) {
                        }
                        post_del = false;
                        post_ins = false;
                    }
                    changes = true;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diff_cleanupMerge(diffs);
        }
    }

    public void diff_cleanupMerge(LinkedList<Diff> diffs) {
        Diff nextDiff;
        diffs.add(new Diff(Operation.EQUAL, ""));
        ListIterator<Diff> pointer = diffs.listIterator();
        int count_delete = 0;
        int count_insert = 0;
        String text_delete = "";
        String text_insert = "";
        Diff thisDiff = (Diff)pointer.next();
        Diff prevEqual = null;
        while (thisDiff != null) {
            switch (thisDiff.operation) {
                case INSERT: {
                    ++count_insert;
                    text_insert = text_insert + thisDiff.text;
                    prevEqual = null;
                    break;
                }
                case DELETE: {
                    ++count_delete;
                    text_delete = text_delete + thisDiff.text;
                    prevEqual = null;
                    break;
                }
                case EQUAL: {
                    if (count_delete != 0 || count_insert != 0) {
                        pointer.previous();
                        while (count_delete-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        while (count_insert-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        if (count_delete != 0 && count_insert != 0) {
                            int commonlength = this.diff_commonPrefix(text_insert, text_delete);
                            if (commonlength != 0) {
                                if (pointer.hasPrevious()) {
                                    thisDiff = (Diff)pointer.previous();
                                    assert (thisDiff.operation == Operation.EQUAL) : "Previous diff should have been an equality.";
                                    thisDiff.text = thisDiff.text + text_insert.substring(0, commonlength);
                                    pointer.next();
                                } else {
                                    pointer.add(new Diff(Operation.EQUAL, text_insert.substring(0, commonlength)));
                                }
                                text_insert = text_insert.substring(commonlength);
                                text_delete = text_delete.substring(commonlength);
                            }
                            if ((commonlength = this.diff_commonSuffix(text_insert, text_delete)) != 0) {
                                thisDiff = (Diff)pointer.next();
                                thisDiff.text = text_insert.substring(text_insert.length() - commonlength) + thisDiff.text;
                                text_insert = text_insert.substring(0, text_insert.length() - commonlength);
                                text_delete = text_delete.substring(0, text_delete.length() - commonlength);
                                pointer.previous();
                            }
                        }
                        if (text_delete.length() != 0) {
                            pointer.add(new Diff(Operation.DELETE, text_delete));
                        }
                        if (text_insert.length() != 0) {
                            pointer.add(new Diff(Operation.INSERT, text_insert));
                        }
                        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    } else if (prevEqual != null) {
                        prevEqual.text = prevEqual.text + thisDiff.text;
                        pointer.remove();
                        thisDiff = (Diff)pointer.previous();
                        pointer.next();
                    }
                    count_insert = 0;
                    count_delete = 0;
                    text_delete = "";
                    text_insert = "";
                    prevEqual = thisDiff;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (diffs.getLast().text.length() == 0) {
            diffs.removeLast();
        }
        boolean changes = false;
        pointer = diffs.listIterator();
        Diff prevDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff diff = nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        while (nextDiff != null) {
            if (prevDiff.operation == Operation.EQUAL && nextDiff.operation == Operation.EQUAL) {
                if (thisDiff.text.endsWith(prevDiff.text)) {
                    thisDiff.text = prevDiff.text + thisDiff.text.substring(0, thisDiff.text.length() - prevDiff.text.length());
                    nextDiff.text = prevDiff.text + nextDiff.text;
                    pointer.previous();
                    pointer.previous();
                    pointer.previous();
                    pointer.remove();
                    pointer.next();
                    thisDiff = (Diff)pointer.next();
                    nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    changes = true;
                } else if (thisDiff.text.startsWith(nextDiff.text)) {
                    prevDiff.text = prevDiff.text + nextDiff.text;
                    thisDiff.text = thisDiff.text.substring(nextDiff.text.length()) + nextDiff.text;
                    pointer.remove();
                    nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    changes = true;
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diff_cleanupMerge(diffs);
        }
    }

    public int diff_xIndex(LinkedList<Diff> diffs, int loc) {
        int chars1 = 0;
        int chars2 = 0;
        int last_chars1 = 0;
        int last_chars2 = 0;
        Diff lastDiff = null;
        for (Diff aDiff : diffs) {
            if (aDiff.operation != Operation.INSERT) {
                chars1 += aDiff.text.length();
            }
            if (aDiff.operation != Operation.DELETE) {
                chars2 += aDiff.text.length();
            }
            if (chars1 > loc) {
                lastDiff = aDiff;
                break;
            }
            last_chars1 = chars1;
            last_chars2 = chars2;
        }
        if (lastDiff != null && lastDiff.operation == Operation.DELETE) {
            return last_chars2;
        }
        return last_chars2 + (loc - last_chars1);
    }

    public String diff_prettyHtml(LinkedList<Diff> diffs) {
        StringBuilder html = new StringBuilder();
        int i = 0;
        for (Diff aDiff : diffs) {
            String text = aDiff.text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "&para;<BR>");
            switch (aDiff.operation) {
                case INSERT: {
                    html.append("<INS STYLE=\"background:#E6FFE6;\" TITLE=\"i=").append(i).append("\">").append(text).append("</INS>");
                    break;
                }
                case DELETE: {
                    html.append("<DEL STYLE=\"background:#FFE6E6;\" TITLE=\"i=").append(i).append("\">").append(text).append("</DEL>");
                    break;
                }
                case EQUAL: {
                    html.append("<SPAN TITLE=\"i=").append(i).append("\">").append(text).append("</SPAN>");
                }
            }
            if (aDiff.operation == Operation.DELETE) continue;
            i += aDiff.text.length();
        }
        return html.toString();
    }

    public String diff_text1(LinkedList<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        for (Diff aDiff : diffs) {
            if (aDiff.operation == Operation.INSERT) continue;
            text.append(aDiff.text);
        }
        return text.toString();
    }

    public String diff_text2(LinkedList<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        for (Diff aDiff : diffs) {
            if (aDiff.operation == Operation.DELETE) continue;
            text.append(aDiff.text);
        }
        return text.toString();
    }

    public int diff_levenshtein(LinkedList<Diff> diffs) {
        int levenshtein = 0;
        int insertions = 0;
        int deletions = 0;
        for (Diff aDiff : diffs) {
            switch (aDiff.operation) {
                case INSERT: {
                    insertions += aDiff.text.length();
                    break;
                }
                case DELETE: {
                    deletions += aDiff.text.length();
                    break;
                }
                case EQUAL: {
                    levenshtein += Math.max(insertions, deletions);
                    insertions = 0;
                    deletions = 0;
                }
            }
        }
        return levenshtein += Math.max(insertions, deletions);
    }

    public String diff_toDelta(LinkedList<Diff> diffs) {
        StringBuilder text = new StringBuilder();
        for (Diff aDiff : diffs) {
            switch (aDiff.operation) {
                case INSERT: {
                    try {
                        text.append("+").append(URLEncoder.encode(aDiff.text, "UTF-8").replace('+', ' ')).append("\t");
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new Error("This system does not support UTF-8.", e);
                    }
                }
                case DELETE: {
                    text.append("-").append(aDiff.text.length()).append("\t");
                    break;
                }
                case EQUAL: {
                    text.append("=").append(aDiff.text.length()).append("\t");
                }
            }
        }
        String delta = text.toString();
        if (delta.length() != 0) {
            delta = delta.substring(0, delta.length() - 1);
            delta = diff_match_patch.unescapeForEncodeUriCompatability(delta);
        }
        return delta;
    }

    public LinkedList<Diff> diff_fromDelta(String text1, String delta) throws IllegalArgumentException {
        String[] tokens;
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        int pointer = 0;
        block11: for (String token : tokens = delta.split("\t")) {
            if (token.length() == 0) continue;
            String param = token.substring(1);
            switch (token.charAt(0)) {
                case '+': {
                    param = param.replace("+", "%2B");
                    try {
                        param = URLDecoder.decode(param, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new Error("This system does not support UTF-8.", e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Illegal escape in diff_fromDelta: " + param, e);
                    }
                    diffs.add(new Diff(Operation.INSERT, param));
                    continue block11;
                }
                case '-': 
                case '=': {
                    String text;
                    int n;
                    try {
                        n = Integer.parseInt(param);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid number in diff_fromDelta: " + param, e);
                    }
                    if (n < 0) {
                        throw new IllegalArgumentException("Negative number in diff_fromDelta: " + param);
                    }
                    try {
                        text = text1.substring(pointer, pointer += n);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("Delta length (" + pointer + ") larger than source text length (" + text1.length() + ").", e);
                    }
                    if (token.charAt(0) == '=') {
                        diffs.add(new Diff(Operation.EQUAL, text));
                        continue block11;
                    }
                    diffs.add(new Diff(Operation.DELETE, text));
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Invalid diff operation in diff_fromDelta: " + token.charAt(0));
                }
            }
        }
        if (pointer != text1.length()) {
            throw new IllegalArgumentException("Delta length (" + pointer + ") smaller than source text length (" + text1.length() + ").");
        }
        return diffs;
    }

    public int match_main(String text, String pattern, int loc) {
        loc = Math.max(0, Math.min(loc, text.length()));
        if (text.equals(pattern)) {
            return 0;
        }
        if (text.length() == 0) {
            return -1;
        }
        if (loc + pattern.length() <= text.length() && text.substring(loc, loc + pattern.length()).equals(pattern)) {
            return loc;
        }
        return this.match_bitap(text, pattern, loc);
    }

    protected int match_bitap(String text, String pattern, int loc) {
        assert (this.Match_MaxBits == 0 || pattern.length() <= this.Match_MaxBits) : "Pattern too long for this application.";
        Map<Character, Integer> s = this.match_alphabet(pattern);
        double score_threshold = this.Match_Threshold;
        int best_loc = text.indexOf(pattern, loc);
        if (best_loc != -1) {
            score_threshold = Math.min(this.match_bitapScore(0, best_loc, loc, pattern), score_threshold);
            best_loc = text.lastIndexOf(pattern, loc + pattern.length());
            if (best_loc != -1) {
                score_threshold = Math.min(this.match_bitapScore(0, best_loc, loc, pattern), score_threshold);
            }
        }
        int matchmask = 1 << pattern.length() - 1;
        best_loc = -1;
        int bin_max = pattern.length() + text.length();
        int[] last_rd = new int[]{};
        for (int d = 0; d < pattern.length(); ++d) {
            int bin_min = 0;
            int bin_mid = bin_max;
            while (bin_min < bin_mid) {
                if (this.match_bitapScore(d, loc + bin_mid, loc, pattern) <= score_threshold) {
                    bin_min = bin_mid;
                } else {
                    bin_max = bin_mid;
                }
                bin_mid = (bin_max - bin_min) / 2 + bin_min;
            }
            bin_max = bin_mid;
            int start = Math.max(1, loc - bin_mid + 1);
            int finish = Math.min(loc + bin_mid, text.length()) + pattern.length();
            int[] rd = new int[finish + 2];
            rd[finish + 1] = (1 << d) - 1;
            for (int j = finish; j >= start; --j) {
                double score;
                int charMatch = text.length() <= j - 1 || !s.containsKey(Character.valueOf(text.charAt(j - 1))) ? 0 : s.get(Character.valueOf(text.charAt(j - 1)));
                rd[j] = d == 0 ? (rd[j + 1] << 1 | 1) & charMatch : (rd[j + 1] << 1 | 1) & charMatch | ((last_rd[j + 1] | last_rd[j]) << 1 | 1) | last_rd[j + 1];
                if ((rd[j] & matchmask) == 0 || !((score = this.match_bitapScore(d, j - 1, loc, pattern)) <= score_threshold)) continue;
                score_threshold = score;
                best_loc = j - 1;
                if (best_loc <= loc) break;
                start = Math.max(1, 2 * loc - best_loc);
            }
            if (this.match_bitapScore(d + 1, loc, loc, pattern) > score_threshold) break;
            last_rd = rd;
        }
        return best_loc;
    }

    private double match_bitapScore(int e, int x, int loc, String pattern) {
        float accuracy = (float)e / (float)pattern.length();
        int proximity = Math.abs(loc - x);
        if (this.Match_Distance == 0) {
            return proximity == 0 ? (double)accuracy : 1.0;
        }
        return accuracy + (float)proximity / (float)this.Match_Distance;
    }

    protected Map<Character, Integer> match_alphabet(String pattern) {
        char[] char_pattern;
        HashMap<Character, Integer> s = new HashMap<Character, Integer>();
        for (char c : char_pattern = pattern.toCharArray()) {
            s.put(Character.valueOf(c), 0);
        }
        int i = 0;
        for (char c : char_pattern) {
            s.put(Character.valueOf(c), (Integer)s.get(Character.valueOf(c)) | 1 << pattern.length() - i - 1);
            ++i;
        }
        return s;
    }

    protected void patch_addContext(Patch patch, String text) {
        String suffix;
        if (text.length() == 0) {
            return;
        }
        String pattern = text.substring(patch.start2, patch.start2 + patch.length1);
        int padding = 0;
        while (text.indexOf(pattern) != text.lastIndexOf(pattern) && pattern.length() < this.Match_MaxBits - this.Patch_Margin - this.Patch_Margin) {
            pattern = text.substring(Math.max(0, patch.start2 - (padding += this.Patch_Margin)), Math.min(text.length(), patch.start2 + patch.length1 + padding));
        }
        String prefix = text.substring(Math.max(0, patch.start2 - (padding += this.Patch_Margin)), patch.start2);
        if (prefix.length() != 0) {
            patch.diffs.addFirst(new Diff(Operation.EQUAL, prefix));
        }
        if ((suffix = text.substring(patch.start2 + patch.length1, Math.min(text.length(), patch.start2 + patch.length1 + padding))).length() != 0) {
            patch.diffs.addLast(new Diff(Operation.EQUAL, suffix));
        }
        patch.start1 -= prefix.length();
        patch.start2 -= prefix.length();
        patch.length1 += prefix.length() + suffix.length();
        patch.length2 += prefix.length() + suffix.length();
    }

    public LinkedList<Patch> patch_make(String text1, String text2) {
        LinkedList<Diff> diffs = this.diff_main(text1, text2, true);
        if (diffs.size() > 2) {
            this.diff_cleanupSemantic(diffs);
            this.diff_cleanupEfficiency(diffs);
        }
        return this.patch_make(text1, diffs);
    }

    public LinkedList<Patch> patch_make(LinkedList<Diff> diffs) {
        String text1 = this.diff_text1(diffs);
        return this.patch_make(text1, diffs);
    }

    public LinkedList<Patch> patch_make(String text1, String text2, LinkedList<Diff> diffs) {
        return this.patch_make(text1, diffs);
    }

    public LinkedList<Patch> patch_make(String text1, LinkedList<Diff> diffs) {
        LinkedList<Patch> patches = new LinkedList<Patch>();
        if (diffs.isEmpty()) {
            return patches;
        }
        Patch patch = new Patch();
        int char_count1 = 0;
        int char_count2 = 0;
        String prepatch_text = text1;
        String postpatch_text = text1;
        for (Diff aDiff : diffs) {
            if (patch.diffs.isEmpty() && aDiff.operation != Operation.EQUAL) {
                patch.start1 = char_count1;
                patch.start2 = char_count2;
            }
            switch (aDiff.operation) {
                case INSERT: {
                    patch.diffs.add(aDiff);
                    patch.length2 += aDiff.text.length();
                    postpatch_text = postpatch_text.substring(0, char_count2) + aDiff.text + postpatch_text.substring(char_count2);
                    break;
                }
                case DELETE: {
                    patch.length1 += aDiff.text.length();
                    patch.diffs.add(aDiff);
                    postpatch_text = postpatch_text.substring(0, char_count2) + postpatch_text.substring(char_count2 + aDiff.text.length());
                    break;
                }
                case EQUAL: {
                    if (aDiff.text.length() <= 2 * this.Patch_Margin && !patch.diffs.isEmpty() && aDiff != diffs.getLast()) {
                        patch.diffs.add(aDiff);
                        patch.length1 += aDiff.text.length();
                        patch.length2 += aDiff.text.length();
                    }
                    if (aDiff.text.length() < 2 * this.Patch_Margin || patch.diffs.isEmpty()) break;
                    this.patch_addContext(patch, prepatch_text);
                    patches.add(patch);
                    patch = new Patch();
                    prepatch_text = postpatch_text;
                    char_count1 = char_count2;
                }
            }
            if (aDiff.operation != Operation.INSERT) {
                char_count1 += aDiff.text.length();
            }
            if (aDiff.operation == Operation.DELETE) continue;
            char_count2 += aDiff.text.length();
        }
        if (!patch.diffs.isEmpty()) {
            this.patch_addContext(patch, prepatch_text);
            patches.add(patch);
        }
        return patches;
    }

    public LinkedList<Patch> patch_deepCopy(LinkedList<Patch> patches) {
        LinkedList<Patch> patchesCopy = new LinkedList<Patch>();
        for (Patch aPatch : patches) {
            Patch patchCopy = new Patch();
            for (Diff aDiff : aPatch.diffs) {
                Diff diffCopy = new Diff(aDiff.operation, aDiff.text);
                patchCopy.diffs.add(diffCopy);
            }
            patchCopy.start1 = aPatch.start1;
            patchCopy.start2 = aPatch.start2;
            patchCopy.length1 = aPatch.length1;
            patchCopy.length2 = aPatch.length2;
            patchesCopy.add(patchCopy);
        }
        return patchesCopy;
    }

    public Object[] patch_apply(LinkedList<Patch> patches, String text) {
        if (patches.isEmpty()) {
            return new Object[]{text, new boolean[0]};
        }
        patches = this.patch_deepCopy(patches);
        String nullPadding = this.patch_addPadding(patches);
        text = nullPadding + text + nullPadding;
        this.patch_splitMax(patches);
        int x = 0;
        int delta = 0;
        boolean[] results = new boolean[patches.size()];
        for (Patch aPatch : patches) {
            int start_loc;
            int expected_loc = aPatch.start2 + delta;
            String text1 = this.diff_text1(aPatch.diffs);
            int end_loc = -1;
            if (text1.length() > this.Match_MaxBits) {
                start_loc = this.match_main(text, text1.substring(0, this.Match_MaxBits), expected_loc);
                if (start_loc != -1 && ((end_loc = this.match_main(text, text1.substring(text1.length() - this.Match_MaxBits), expected_loc + text1.length() - this.Match_MaxBits)) == -1 || start_loc >= end_loc)) {
                    start_loc = -1;
                }
            } else {
                start_loc = this.match_main(text, text1, expected_loc);
            }
            if (start_loc == -1) {
                results[x] = false;
                delta -= aPatch.length2 - aPatch.length1;
            } else {
                results[x] = true;
                delta = start_loc - expected_loc;
                String text2 = end_loc == -1 ? text.substring(start_loc, Math.min(start_loc + text1.length(), text.length())) : text.substring(start_loc, Math.min(end_loc + this.Match_MaxBits, text.length()));
                if (text1.equals(text2)) {
                    text = text.substring(0, start_loc) + this.diff_text2(aPatch.diffs) + text.substring(start_loc + text1.length());
                } else {
                    LinkedList<Diff> diffs = this.diff_main(text1, text2, false);
                    if (text1.length() > this.Match_MaxBits && (float)this.diff_levenshtein(diffs) / (float)text1.length() > this.Patch_DeleteThreshold) {
                        results[x] = false;
                    } else {
                        this.diff_cleanupSemanticLossless(diffs);
                        int index1 = 0;
                        for (Diff aDiff : aPatch.diffs) {
                            if (aDiff.operation != Operation.EQUAL) {
                                int index2 = this.diff_xIndex(diffs, index1);
                                if (aDiff.operation == Operation.INSERT) {
                                    text = text.substring(0, start_loc + index2) + aDiff.text + text.substring(start_loc + index2);
                                } else if (aDiff.operation == Operation.DELETE) {
                                    text = text.substring(0, start_loc + index2) + text.substring(start_loc + this.diff_xIndex(diffs, index1 + aDiff.text.length()));
                                }
                            }
                            if (aDiff.operation == Operation.DELETE) continue;
                            index1 += aDiff.text.length();
                        }
                    }
                }
            }
            ++x;
        }
        text = text.substring(nullPadding.length(), text.length() - nullPadding.length());
        return new Object[]{text, results};
    }

    public String patch_addPadding(LinkedList<Patch> patches) {
        int extraLength;
        int paddingLength = this.Patch_Margin;
        String nullPadding = "";
        for (int x = 1; x <= paddingLength; ++x) {
            nullPadding = nullPadding + String.valueOf((char)x);
        }
        for (Patch aPatch : patches) {
            aPatch.start1 += paddingLength;
            aPatch.start2 += paddingLength;
        }
        Patch patch = patches.getFirst();
        LinkedList<Diff> diffs = patch.diffs;
        if (diffs.isEmpty() || diffs.getFirst().operation != Operation.EQUAL) {
            diffs.addFirst(new Diff(Operation.EQUAL, nullPadding));
            patch.start1 -= paddingLength;
            patch.start2 -= paddingLength;
            patch.length1 += paddingLength;
            patch.length2 += paddingLength;
        } else if (paddingLength > diffs.getFirst().text.length()) {
            Diff firstDiff = diffs.getFirst();
            extraLength = paddingLength - firstDiff.text.length();
            firstDiff.text = nullPadding.substring(firstDiff.text.length()) + firstDiff.text;
            patch.start1 -= extraLength;
            patch.start2 -= extraLength;
            patch.length1 += extraLength;
            patch.length2 += extraLength;
        }
        patch = patches.getLast();
        diffs = patch.diffs;
        if (diffs.isEmpty() || diffs.getLast().operation != Operation.EQUAL) {
            diffs.addLast(new Diff(Operation.EQUAL, nullPadding));
            patch.length1 += paddingLength;
            patch.length2 += paddingLength;
        } else if (paddingLength > diffs.getLast().text.length()) {
            Diff lastDiff = diffs.getLast();
            extraLength = paddingLength - lastDiff.text.length();
            lastDiff.text = lastDiff.text + nullPadding.substring(0, extraLength);
            patch.length1 += extraLength;
            patch.length2 += extraLength;
        }
        return nullPadding;
    }

    public void patch_splitMax(LinkedList<Patch> patches) {
        Patch bigpatch;
        ListIterator<Patch> pointer = patches.listIterator();
        Patch patch = bigpatch = pointer.hasNext() ? (Patch)pointer.next() : null;
        while (bigpatch != null) {
            if (bigpatch.length1 <= this.Match_MaxBits) {
                bigpatch = pointer.hasNext() ? (Patch)pointer.next() : null;
                continue;
            }
            pointer.remove();
            int patch_size = this.Match_MaxBits;
            int start1 = bigpatch.start1;
            int start2 = bigpatch.start2;
            String precontext = "";
            while (!bigpatch.diffs.isEmpty()) {
                Patch patch2 = new Patch();
                boolean empty = true;
                patch2.start1 = start1 - precontext.length();
                patch2.start2 = start2 - precontext.length();
                if (precontext.length() != 0) {
                    patch2.length1 = patch2.length2 = precontext.length();
                    patch2.diffs.add(new Diff(Operation.EQUAL, precontext));
                }
                while (!bigpatch.diffs.isEmpty() && patch2.length1 < patch_size - this.Patch_Margin) {
                    Operation diff_type = bigpatch.diffs.getFirst().operation;
                    String diff_text = bigpatch.diffs.getFirst().text;
                    if (diff_type == Operation.INSERT) {
                        patch2.length2 += diff_text.length();
                        start2 += diff_text.length();
                        patch2.diffs.addLast(bigpatch.diffs.removeFirst());
                        empty = false;
                        continue;
                    }
                    if (diff_type == Operation.DELETE && patch2.diffs.size() == 1 && patch2.diffs.getFirst().operation == Operation.EQUAL && diff_text.length() > 2 * patch_size) {
                        patch2.length1 += diff_text.length();
                        start1 += diff_text.length();
                        empty = false;
                        patch2.diffs.add(new Diff(diff_type, diff_text));
                        bigpatch.diffs.removeFirst();
                        continue;
                    }
                    diff_text = diff_text.substring(0, Math.min(diff_text.length(), patch_size - patch2.length1 - this.Patch_Margin));
                    patch2.length1 += diff_text.length();
                    start1 += diff_text.length();
                    if (diff_type == Operation.EQUAL) {
                        patch2.length2 += diff_text.length();
                        start2 += diff_text.length();
                    } else {
                        empty = false;
                    }
                    patch2.diffs.add(new Diff(diff_type, diff_text));
                    if (diff_text.equals(bigpatch.diffs.getFirst().text)) {
                        bigpatch.diffs.removeFirst();
                        continue;
                    }
                    bigpatch.diffs.getFirst().text = bigpatch.diffs.getFirst().text.substring(diff_text.length());
                }
                precontext = this.diff_text2(patch2.diffs);
                precontext = precontext.substring(Math.max(0, precontext.length() - this.Patch_Margin));
                String postcontext = this.diff_text1(bigpatch.diffs).length() > this.Patch_Margin ? this.diff_text1(bigpatch.diffs).substring(0, this.Patch_Margin) : this.diff_text1(bigpatch.diffs);
                if (postcontext.length() != 0) {
                    patch2.length1 += postcontext.length();
                    patch2.length2 += postcontext.length();
                    if (!patch2.diffs.isEmpty() && patch2.diffs.getLast().operation == Operation.EQUAL) {
                        patch2.diffs.getLast().text = patch2.diffs.getLast().text + postcontext;
                    } else {
                        patch2.diffs.add(new Diff(Operation.EQUAL, postcontext));
                    }
                }
                if (empty) continue;
                pointer.add(patch2);
            }
            bigpatch = pointer.hasNext() ? (Patch)pointer.next() : null;
        }
    }

    public String patch_toText(List<Patch> patches) {
        StringBuilder text = new StringBuilder();
        for (Patch aPatch : patches) {
            text.append(aPatch);
        }
        return text.toString();
    }

    public List<Patch> patch_fromText(String textline) throws IllegalArgumentException {
        LinkedList<Patch> patches = new LinkedList<Patch>();
        if (textline.length() == 0) {
            return patches;
        }
        List<String> textList = Arrays.asList(textline.split("\n"));
        LinkedList<String> text = new LinkedList<String>(textList);
        Pattern patchHeader = Pattern.compile("^@@ -(\\d+),?(\\d*) \\+(\\d+),?(\\d*) @@$");
        block5: while (!text.isEmpty()) {
            Matcher m = patchHeader.matcher(text.getFirst());
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid patch string: " + text.getFirst());
            }
            Patch patch = new Patch();
            patches.add(patch);
            patch.start1 = Integer.parseInt(m.group(1));
            if (m.group(2).length() == 0) {
                --patch.start1;
                patch.length1 = 1;
            } else if (m.group(2).equals("0")) {
                patch.length1 = 0;
            } else {
                --patch.start1;
                patch.length1 = Integer.parseInt(m.group(2));
            }
            patch.start2 = Integer.parseInt(m.group(3));
            if (m.group(4).length() == 0) {
                --patch.start2;
                patch.length2 = 1;
            } else if (m.group(4).equals("0")) {
                patch.length2 = 0;
            } else {
                --patch.start2;
                patch.length2 = Integer.parseInt(m.group(4));
            }
            text.removeFirst();
            while (!text.isEmpty()) {
                char sign;
                try {
                    sign = text.getFirst().charAt(0);
                }
                catch (IndexOutOfBoundsException e) {
                    text.removeFirst();
                    continue;
                }
                String line = text.getFirst().substring(1);
                line = line.replace("+", "%2B");
                try {
                    line = URLDecoder.decode(line, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("This system does not support UTF-8.", e);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Illegal escape in patch_fromText: " + line, e);
                }
                if (sign == '-') {
                    patch.diffs.add(new Diff(Operation.DELETE, line));
                } else if (sign == '+') {
                    patch.diffs.add(new Diff(Operation.INSERT, line));
                } else if (sign == ' ') {
                    patch.diffs.add(new Diff(Operation.EQUAL, line));
                } else {
                    if (sign == '@') continue block5;
                    throw new IllegalArgumentException("Invalid patch mode '" + sign + "' in: " + line);
                }
                text.removeFirst();
            }
        }
        return patches;
    }

    private static String unescapeForEncodeUriCompatability(String str) {
        return str.replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%3B", ";").replace("%2F", "/").replace("%3F", "?").replace("%3A", ":").replace("%40", "@").replace("%26", "&").replace("%3D", "=").replace("%2B", "+").replace("%24", "$").replace("%2C", ",").replace("%23", "#");
    }

    public static class Patch {
        public LinkedList<Diff> diffs = new LinkedList();
        public int start1;
        public int start2;
        public int length1;
        public int length2;

        public String toString() {
            String coords1 = this.length1 == 0 ? this.start1 + ",0" : (this.length1 == 1 ? Integer.toString(this.start1 + 1) : this.start1 + 1 + "," + this.length1);
            String coords2 = this.length2 == 0 ? this.start2 + ",0" : (this.length2 == 1 ? Integer.toString(this.start2 + 1) : this.start2 + 1 + "," + this.length2);
            StringBuilder text = new StringBuilder();
            text.append("@@ -").append(coords1).append(" +").append(coords2).append(" @@\n");
            for (Diff aDiff : this.diffs) {
                switch (aDiff.operation) {
                    case INSERT: {
                        text.append('+');
                        break;
                    }
                    case DELETE: {
                        text.append('-');
                        break;
                    }
                    case EQUAL: {
                        text.append(' ');
                    }
                }
                try {
                    text.append(URLEncoder.encode(aDiff.text, "UTF-8").replace('+', ' ')).append("\n");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("This system does not support UTF-8.", e);
                }
            }
            return diff_match_patch.unescapeForEncodeUriCompatability(text.toString());
        }
    }

    public static class Diff {
        public Operation operation;
        public String text;

        public Diff(Operation operation, String text) {
            this.operation = operation;
            this.text = text;
        }

        public String toString() {
            String prettyText = this.text.replace('\n', '\u00b6');
            return "Diff(" + (Object)((Object)this.operation) + ",\"" + prettyText + "\")";
        }

        public boolean equals(Object d) {
            try {
                return ((Diff)d).operation == this.operation && ((Diff)d).text.equals(this.text);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }

    public static enum Operation {
        DELETE,
        INSERT,
        EQUAL;

    }

    protected static class LinesToCharsResult {
        protected String chars1;
        protected String chars2;
        protected List<String> lineArray;

        protected LinesToCharsResult(String chars1, String chars2, List<String> lineArray) {
            this.chars1 = chars1;
            this.chars2 = chars2;
            this.lineArray = lineArray;
        }
    }
}

