/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

public class FileLockDetector {
    private File fileToLock;
    private RandomAccessFile randomAccessFile;
    private FileLock lock;

    public FileLockDetector(File fileToLock) {
        this.fileToLock = fileToLock;
    }

    public boolean obtain() throws IOException {
        return this.obtain(0);
    }

    public boolean obtain(int millisecondsToWait) throws IOException {
        if (this.lock != null) {
            return true;
        }
        this.randomAccessFile = new RandomAccessFile(this.fileToLock, "r");
        this.lock = this.randomAccessFile.getChannel().tryLock(0L, Long.MAX_VALUE, true);
        if (this.lock == null) {
            return false;
        }
        if (millisecondsToWait == 0) {
            return true;
        }
        if (this.isFileBeingModified(millisecondsToWait)) {
            this.release();
            return false;
        }
        return true;
    }

    public void release() throws IOException {
        if (this.lock != null) {
            this.lock.release();
        }
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
        }
        this.lock = null;
        this.randomAccessFile = null;
    }

    private boolean isFileBeingModified(int millisecondsToWait) {
        long mod = this.fileToLock.lastModified();
        long length = this.fileToLock.length();
        try {
            Thread.sleep(millisecondsToWait);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return this.fileToLock.lastModified() != mod || this.fileToLock.length() != length;
    }
}

