/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.misc.infrastructure;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class DirectoryClassLoader
extends URLClassLoader {
    public DirectoryClassLoader(ClassLoader parent, File directory) {
        super(DirectoryClassLoader.scanDir(directory), parent);
    }

    private static URL[] scanDir(File directory) {
        try {
            File[] files = directory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !pathname.isHidden() && !pathname.isDirectory();
                }
            });
            if (files == null) {
                files = new File[]{};
            }
            URL[] urls = new URL[files.length + 1];
            for (int n = 0; n < files.length; ++n) {
                urls[n] = files[n].toURI().toURL();
            }
            urls[n] = directory.toURI().toURL();
            return urls;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

