/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.exception.UserCanceledException;
import com.prosc.infrastructure.Platform;
import com.prosc.io.ProcessExecutionException;
import com.prosc.thread.MyThreadFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class ProcessUtils {
    private static final Logger log = Logger.getLogger(ProcessUtils.class.getName());

    private ProcessUtils() {
    }

    public static byte[] doShellCommand(String[] commandArray, @Nullable Map<String, String> env, @Nullable File workingDir) throws ProcessExecutionException, UserCanceledException {
        try {
            return ProcessUtils.doShellCommand(commandArray, env, workingDir, 0, true);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] doShellCommand(String[] commandArray, @Nullable Map<String, String> env, @Nullable File workingDir, boolean redirectStdErr) throws ProcessExecutionException, IOException, UserCanceledException {
        try {
            return ProcessUtils.doShellCommand(commandArray, env, workingDir, 0, redirectStdErr);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] doShellCommand(String[] commandArray, @Nullable Map<String, String> env, @Nullable File workingDir, int timeout) throws ProcessExecutionException, IOException, UserCanceledException, TimeoutException {
        return ProcessUtils.doShellCommand(commandArray, env, workingDir, timeout, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] doShellCommand(final String[] commandArray, final @Nullable Map<String, String> env, final @Nullable File workingDir, int timeout, final boolean redirectStdErr) throws ProcessExecutionException, TimeoutException, UserCanceledException {
        Callable<byte[]> callable = new Callable<byte[]>(){

            /*
             * Exception decompiling
             */
            @Override
            public byte[] call() throws ProcessExecutionException, InterruptedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[TRYBLOCK]], but top level block is 2[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        try {
            if (timeout <= 0) {
                return (byte[])callable.call();
            }
            ExecutorService service = Executors.newSingleThreadExecutor(new MyThreadFactory("ProcessUtils"));
            Future<byte[]> future = service.submit(callable);
            try {
                byte[] byArray = future.get(timeout, TimeUnit.MILLISECONDS);
                return byArray;
            }
            catch (TimeoutException e) {
                log.info("Process exceeded timeout; will cancel it.");
                future.cancel(true);
                throw e;
            }
            catch (InterruptedException e) {
                future.cancel(true);
                throw e;
            }
            finally {
                service.shutdown();
            }
        }
        catch (Throwable t) {
            if (t instanceof ExecutionException) {
                log.log(Level.WARNING, "Exception in ProcessUtils, stack trace up to this point: " + new RuntimeException("Stack trace only"));
                t = t.getCause();
            }
            if (t instanceof ProcessExecutionException) {
                throw (ProcessExecutionException)t;
            }
            if (t instanceof InterruptedException) {
                throw new UserCanceledException("User canceled '" + commandArray[0] + "' command", t);
            }
            if (t instanceof TimeoutException) {
                throw (TimeoutException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (!(t instanceof RuntimeException)) throw new RuntimeException(t);
            throw (RuntimeException)t;
        }
    }

    public static Collection<String> findPids(String processName, String commandSearch) throws TimeoutException {
        String[] lines;
        String[] cmd = Platform.isWin() ? new String[]{"wmic", "PROCESS", "where", "name like '%" + processName + "%'", "GET", "Processid,Caption,Commandline"} : new String[]{"ps", "axwww"};
        try {
            byte[] bytes = ProcessUtils.doShellCommand(cmd, null, null, 15000);
            String searchIn = new String(bytes, StandardCharsets.UTF_8);
            lines = searchIn.split(System.getProperty("line.separator"));
        }
        catch (TimeoutException e) {
            log.log(Level.SEVERE, "Process timed out: " + Arrays.asList(cmd), e);
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LinkedList<String> result = new LinkedList<String>();
        for (String line : lines) {
            if (!line.contains(processName) || !line.contains(commandSearch)) continue;
            if (Platform.isWin()) {
                line = line.trim();
                result.add(line.substring(line.lastIndexOf(32) + 1));
                continue;
            }
            result.add(line.substring(0, line.indexOf(" ")));
        }
        return result;
    }

    public static String getJavaPath() {
        File result;
        String pathToExecutable = System.getenv("_RUNJAVA");
        if (pathToExecutable == null || !new File(pathToExecutable).exists()) {
            pathToExecutable = System.getenv("_EXECJAVA");
        }
        if (pathToExecutable == null || !new File(pathToExecutable).exists()) {
            String javaHome = System.getProperty("java.home");
            pathToExecutable = javaHome + File.separator + "bin" + File.separator + "java";
            if (Platform.isWin()) {
                pathToExecutable = pathToExecutable + ".exe";
            }
            if (!(result = new File(pathToExecutable)).exists()) {
                throw new IllegalStateException("No file found at " + pathToExecutable);
            }
        } else {
            result = new File(pathToExecutable);
        }
        if (result.canExecute()) {
            return result.getAbsolutePath();
        }
        throw new IllegalStateException("A file exists at '" + result.getPath() + "', but it is not executable");
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

