/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.shared.StringUtils;
import java.nio.charset.StandardCharsets;

public class ProcessExecutionException
extends Exception {
    private final byte[] data;
    private final int exitStatus;

    public ProcessExecutionException(byte[] data, String errorMessage, int exitStatus) {
        super(StringUtils.isEmpty(errorMessage, true) ? "Exit code " + exitStatus : errorMessage);
        this.data = data;
        this.exitStatus = exitStatus;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    @Override
    public String getMessage() {
        String result = super.getMessage();
        if (StringUtils.isEmpty(result)) {
            result = new String(this.data, StandardCharsets.UTF_8);
        }
        return result;
    }
}

