/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class StringLogHandler
extends Handler {
    private final int maxSize;
    private final LinkedList<LogRecord> entries = new LinkedList();
    private int currentSize = 0;

    public StringLogHandler() {
        this(Integer.MAX_VALUE);
    }

    public StringLogHandler(int maxLines) {
        this.maxSize = maxLines;
        this.setFormatter(new SimpleFormatter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (record.getLevel().intValue() >= this.getLevel().intValue()) {
            StringLogHandler stringLogHandler = this;
            synchronized (stringLogHandler) {
                this.entries.addLast(record);
                ++this.currentSize;
                while (this.currentSize > this.maxSize) {
                    this.entries.removeFirst();
                    --this.currentSize;
                }
            }
        }
    }

    public synchronized void clear() {
        this.entries.clear();
    }

    public synchronized String getLogOutput() {
        StringBuilder output = new StringBuilder(this.entries.size() * 256);
        boolean addDelim = false;
        Formatter formatter = this.getFormatter();
        for (LogRecord record : this.entries) {
            if (addDelim) {
                output.append('\n');
            }
            addDelim = true;
            output.append(formatter.format(record));
        }
        return output.toString();
    }

    public List<LogRecord> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.clear();
    }
}

