/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.format;

class NumberTextFormatter {
    private static final String[] majorNames = new String[]{"", " thousand", " million", " billion", " trillion", " quadrillion", " quintillion"};
    private static final String[] tensNames = new String[]{"", " ten", " twenty", " thirty", " fourty", " fifty", " sixty", " seventy", " eighty", " ninety"};
    private static final String[] numNames = new String[]{"", " one", " two", " three", " four", " five", " six", " seven", " eight", " nine", " ten", " eleven", " twelve", " thirteen", " fourteen", " fifteen", " sixteen", " seventeen", " eighteen", " nineteen"};

    NumberTextFormatter() {
    }

    private String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            soFar = tensNames[(number /= 10) % 10] + soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        return numNames[number] + " hundred" + soFar;
    }

    public String convert(int number) {
        if (number == 0) {
            return "zero";
        }
        String prefix = "";
        if (number < 0) {
            number = -number;
            prefix = "negative";
        }
        String soFar = "";
        int place = 0;
        do {
            int n;
            if ((n = number % 1000) != 0) {
                String s = this.convertLessThanOneThousand(n);
                soFar = s + majorNames[place] + soFar;
            }
            ++place;
        } while ((number /= 1000) > 0);
        return (prefix + soFar).trim();
    }
}

