/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmplugin;

import com.prosc.core.FeedbackException;
import com.prosc.fmplugin.ChartModelInterface;
import com.prosc.fmplugin.ChartModelUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.function.LineFunction2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.statistics.Regression;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class TimeSeriesChartModel
implements ChartModelInterface {
    private TimeSeriesCollection timeseriesDataset = new TimeSeriesCollection();
    private JFreeChart timeSeriesChart;
    private Map timeSeriesByName;

    public TimeSeriesChartModel(String name, String timeAxisLabel, String valueAxisLabel) {
        this.timeSeriesChart = ChartFactory.createTimeSeriesChart(name, timeAxisLabel, valueAxisLabel, this.timeseriesDataset, true, false, false);
        this.timeSeriesByName = new HashMap(3);
    }

    @Override
    public void setValue(double value, String seriesName, Comparable date) {
        if (date == null) {
            return;
        }
        if (seriesName == null) {
            return;
        }
        TimeSeries series = (TimeSeries)this.timeSeriesByName.get(seriesName);
        if (series == null) {
            series = new TimeSeries((Comparable)((Object)seriesName), FixedMillisecond.class);
            this.timeSeriesByName.put(seriesName, series);
            this.timeseriesDataset.addSeries(series);
        }
        series.addOrUpdate((RegularTimePeriod)new FixedMillisecond((Date)date), value);
    }

    @Override
    public void setSeriesColor(String seriesName, int red, int green, int blue, int alpha) {
        TimeSeries series = (TimeSeries)this.timeSeriesByName.get(seriesName);
        if (series == null) {
            throw new IllegalArgumentException("Unknown seriesName '" + seriesName + "'.  You should call chartSetColor AFTER adding values to the chart.");
        }
        int index = this.timeseriesDataset.getSeries().indexOf(series);
        if (index < 0) {
            throw new IllegalStateException("Unknown seriesName '" + seriesName + "'.  You should call chartSetColor AFTER adding values to the chart.");
        }
        Color c = ChartModelUtils.createColor(red, green, blue, alpha);
        this.timeSeriesChart.getXYPlot().getRendererForDataset(this.timeseriesDataset).setSeriesPaint(index, c);
    }

    @Override
    public BufferedImage getFinishedChart(int width, int height, Properties additionalParams) throws IOException {
        this.applyAdditionalParams(additionalParams);
        return this.timeSeriesChart.createBufferedImage(width, height);
    }

    private void applyAdditionalParams(Properties p) {
        ChartModelUtils.applyCommonParams(p, this);
    }

    public void createMovingAverage(String seriesName, String avgName, int periodCount, int skip) {
        TimeSeries originalSeries = (TimeSeries)this.timeSeriesByName.get(seriesName);
        if (originalSeries == null) {
            throw new IllegalArgumentException("No time series found with name '" + seriesName + "'.  You must create the time series before creating a moving average");
        }
        TimeSeries movingAverage = MovingAverage.createMovingAverage(originalSeries, avgName, periodCount, skip);
        this.timeSeriesByName.put(avgName, movingAverage);
        this.timeseriesDataset.addSeries(movingAverage);
    }

    public void addRegression(String seriesName, String regressionName, Color color) throws FeedbackException {
        int index;
        TimeSeries timeSeries;
        if (regressionName == null) {
            throw new IllegalArgumentException("regressionName must not be null.");
        }
        if (seriesName != null) {
            timeSeries = (TimeSeries)this.timeSeriesByName.get(seriesName);
            if (timeSeries == null) {
                throw new FeedbackException("Unknown seriesName '" + seriesName + "', call timeSeriesSetDataPoint before adding regression lines.");
            }
            index = this.timeseriesDataset.indexOf(timeSeries);
        } else {
            index = 0;
            if (this.timeseriesDataset.getSeriesCount() == 0) {
                throw new FeedbackException("There are no time series, call timeSeriesSetDataPoint before adding regression lines.");
            }
            timeSeries = this.timeseriesDataset.getSeries(0);
        }
        double[] coefficients = Regression.getOLSRegression(this.timeseriesDataset, index);
        LineFunction2D curve = new LineFunction2D(coefficients[0], coefficients[1]);
        long start = timeSeries.getTimePeriod(0).getFirstMillisecond();
        long end = timeSeries.getTimePeriod(timeSeries.getItemCount() - 1).getFirstMillisecond();
        XYDataset regressionData = DatasetUtilities.sampleFunction2D(curve, start, end, 100, (Comparable)((Object)regressionName));
        XYPlot plot = this.timeSeriesChart.getXYPlot();
        plot.setDataset(1, regressionData);
        XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer(true, false);
        if (color != null) {
            renderer2.setSeriesPaint(0, color);
        }
        plot.setRenderer(1, renderer2);
    }

    @Override
    public JFreeChart getChart() {
        return this.timeSeriesChart;
    }
}

