/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmplugin;

import com.prosc.fmplugin.ChartModelInterface;
import com.prosc.fmplugin.ChartModelUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Properties;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public class LineChartModel
implements ChartModelInterface {
    private DefaultCategoryDataset lineDataSet = new DefaultCategoryDataset();
    private JFreeChart lineChart;

    public LineChartModel(String name, String categoryAxisLabel, String valueAxisLabel, boolean vertical, boolean use3d) {
        PlotOrientation orientation = vertical ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL;
        this.lineChart = use3d ? ChartFactory.createLineChart3D(name, categoryAxisLabel, valueAxisLabel, this.lineDataSet, orientation, true, false, false) : ChartFactory.createLineChart(name, categoryAxisLabel, valueAxisLabel, this.lineDataSet, orientation, true, false, false);
    }

    @Override
    public void setValue(double value, String rowOrSeries, Comparable columnOrCategory) {
        this.lineDataSet.addValue(value, (Comparable)((Object)rowOrSeries), columnOrCategory);
    }

    @Override
    public void setSeriesColor(String category, int red, int green, int blue, int alpha) {
        int seriesIndex = this.lineDataSet.getRowKeys().indexOf(category);
        CategoryPlot plot = this.lineChart.getCategoryPlot();
        if (seriesIndex < 0) {
            throw new IllegalArgumentException("Unknown category '" + category + "'.  You should call chartSetColor AFTER adding values to the chart.");
        }
        Color c = ChartModelUtils.createColor(red, green, blue, alpha);
        plot.getRenderer().setSeriesPaint(seriesIndex, c);
    }

    @Override
    public BufferedImage getFinishedChart(int width, int height, Properties additionalParams) throws IOException {
        this.applyAdditionalParams(additionalParams);
        return this.lineChart.createBufferedImage(width, height);
    }

    private void applyAdditionalParams(Properties p) {
        ChartModelUtils.applyCommonParams(p, this);
    }

    @Override
    public JFreeChart getChart() {
        return this.lineChart;
    }
}

