/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit.types;

import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.types.FMText;
import java.io.IOException;
import java.io.Reader;

public class FMTextReader
extends Reader {
    private FMText textPtr;
    private int length;
    private int pointer = 0;
    private PluginContext context;

    public FMTextReader(FMText textPtr, PluginContext context) {
        this.textPtr = textPtr;
        this.length = textPtr.getTextLength(context);
        this.context = context;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (len > cbuf.length) {
            len = cbuf.length;
        }
        if (len > this.length - this.pointer) {
            len = this.length - this.pointer;
        }
        if (len == 0) {
            return -1;
        }
        this.textPtr.readData(cbuf, this.pointer, len, off, this.context);
        this.pointer += len;
        return len;
    }

    @Override
    public void close() throws IOException {
    }

    public long skip(int n) throws IOException {
        int newPointer = this.pointer + n;
        if (newPointer > this.length) {
            newPointer = this.length;
        }
        long result = newPointer - this.pointer;
        this.pointer = newPointer;
        return result;
    }

    public long getLength() {
        return this.length;
    }
}

