/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.prosc.core.FeedbackException;
import com.prosc.fmkit.FmCalculationException;
import com.prosc.fmkit.PluginBridge2;
import com.prosc.fmkit.PluginContext;
import com.prosc.fmkit.types.FMBinary;
import com.prosc.fmkit.types.FMBinaryInterface;
import com.prosc.fmkit.types.FMData;
import com.prosc.fmkit.types.FileReference;
import com.prosc.fmkit.types.InputStreamInfo;
import com.prosc.io.IOUtils;
import com.prosc.shared.CaseInsensitiveMap;
import com.prosc.shared.StringUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class PluginUtils {
    private static final Logger log = Logger.getLogger(PluginUtils.class.getName());
    public static final char CARRIAGE_RETURN = '\r';
    public static final char NEWLINE = '\n';
    protected static final Pattern MERGE_PATTERN = Pattern.compile("<<([^>+\\-*/^&=\ufffd<>(,;)\\[\\]\"$\\n\\r\"]+)>>");
    private static String PLATFORM_SPECIFIC_LINE_BREAK;
    private static String bootVolumeName;
    private static final boolean IS_MAC;
    private static final boolean IS_WIN;
    private static final boolean IS_LIN;
    private static DateFormat dateFormat;
    private static DateFormat timeFormat;
    private static DateFormat dateTimeFormat;
    private static final String keyValueSeparators = "=: \t\r\n\f";

    public static String mergeString(PluginContext context, String mergeTemplate, Format optionalFormat, boolean checkThread) {
        if (mergeTemplate == null || mergeTemplate.length() == 0) {
            return mergeTemplate;
        }
        Matcher m = MERGE_PATTERN.matcher(mergeTemplate);
        StringBuffer result = new StringBuffer(mergeTemplate.length());
        String tableName = null;
        while (m.find()) {
            FMData value;
            String fieldName = m.group(1);
            try {
                value = context.evaluateExpression(fieldName);
            }
            catch (FmCalculationException e) {
                log.log(Level.SEVERE, "Error evaluating merge field '" + fieldName + "': " + e.toString(), e);
                if (fieldName.indexOf(58) != -1) continue;
                try {
                    if (tableName == null) {
                        tableName = context.evaluateExpression("Get ( LayoutTableName )").getStringData(context);
                    }
                    value = context.evaluateExpression(tableName + "::" + fieldName);
                }
                catch (FmCalculationException e2) {
                    log.log(Level.SEVERE, "Unable to evaluate '" + fieldName + "'': ", e2);
                    continue;
                }
            }
            if (optionalFormat == null) {
                m.appendReplacement(result, "");
                String stringData = value.getStringData(context, checkThread);
                if (stringData == null) continue;
                result.append(stringData);
                continue;
            }
            m.appendReplacement(result, "");
            optionalFormat.format(value, result, null);
        }
        m.appendTail(result);
        return result.toString();
    }

    public static String convertLineBreaksFromFilemaker(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(13) >= 0) {
            s = s.replace('\r', '\n');
        }
        return s;
    }

    public static String convertLineBreaksToFileMaker(String s) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf("\r\n");
        if (index != -1) {
            s = s.replace("\r\n", "\r");
        } else if (PluginUtils.isMac()) {
            if (s.indexOf(10) >= 0) {
                s = s.replace('\n', '\r');
            }
        } else if (s.indexOf(10) != -1) {
            s = s.indexOf(13) != -1 ? s.replaceAll("\n", "") : s.replace('\n', '\r');
        }
        return s;
    }

    public static String layoutObjectAttribute(String objectName, String attributeName, PluginContext context) throws FmCalculationException {
        return context.evaluateExpression("GetLayoutObjectAttribute(\"" + objectName + "\", \"" + attributeName + "\")").getStringData(context);
    }

    public static Rectangle getFileMakerWindowBounds(String objectName, PluginContext context) {
        try {
            int windowLeft = (int)context.evaluateExpression("Get(WindowLeft)").getLongData(context);
            int windowTop = (int)context.evaluateExpression("Get(WindowTop)").getLongData(context);
            int left = Integer.valueOf(PluginUtils.layoutObjectAttribute(objectName, "left", context)) - windowLeft;
            int top = Integer.valueOf(PluginUtils.layoutObjectAttribute(objectName, "top", context)) - windowTop;
            int width = Integer.valueOf(PluginUtils.layoutObjectAttribute(objectName, "width", context));
            int height = Integer.valueOf(PluginUtils.layoutObjectAttribute(objectName, "height", context));
            return new Rectangle(left, top, width, height);
        }
        catch (FmCalculationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Rectangle getFileMakerWindowBounds(PluginContext context) {
        try {
            int left = (int)context.evaluateExpression("Get(WindowLeft)").getLongData(context);
            int top = (int)context.evaluateExpression("Get(WindowTop)").getLongData(context);
            int width = (int)context.evaluateExpression("Get(WindowWidth)").getLongData(context);
            int height = (int)context.evaluateExpression("Get(WindowHeight)").getLongData(context);
            return new Rectangle(left, top, width, height);
        }
        catch (FmCalculationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String platformSpecificNewline() {
        if (PLATFORM_SPECIFIC_LINE_BREAK == null) {
            PLATFORM_SPECIFIC_LINE_BREAK = String.valueOf('\r');
        }
        return PLATFORM_SPECIFIC_LINE_BREAK;
    }

    public static boolean isMac() {
        return IS_MAC;
    }

    public static boolean isLin() {
        return IS_LIN;
    }

    public static boolean isWin() {
        return IS_WIN;
    }

    public static File fileForFMPath(String fmPath) {
        int secondSlash;
        if (fmPath == null) {
            return null;
        }
        log.fine("Getting File for fmPath: " + fmPath);
        int index = fmPath.indexOf(":/");
        if (index != -1 && !fmPath.toLowerCase().startsWith("size:") && FileReference.isValidReferenceString(fmPath)) {
            fmPath = fmPath.substring(index + 1);
        }
        if (fmPath.contains("%20")) {
            fmPath = fmPath.replace("%20", " ");
        }
        File result = new File(fmPath);
        if (PluginUtils.isMac() && (secondSlash = fmPath.indexOf(47, 2)) != -1 && fmPath.startsWith("/") && !fmPath.toLowerCase().startsWith("/volumes/")) {
            String firstPathComponent = fmPath.substring(1, secondSlash);
            File volume = new File("/Volumes", firstPathComponent);
            if (volume.exists()) {
                result = new File("/Volumes", fmPath);
                if (result.exists()) {
                    log.fine("File exists after prepending /Volumes to path name: " + result.getAbsolutePath());
                } else {
                    log.warning("Volume exists at " + volume.getAbsolutePath() + ", but file does not exist at " + result.getAbsolutePath());
                }
            } else if (result.exists()) {
                log.fine("No need to prepend /Volumes, file exists at " + result.getAbsolutePath());
            } else {
                result = new File(fmPath.substring(secondSlash, fmPath.length()));
                if (result.exists()) {
                    log.fine("File exists after removing first path component" + result.getAbsolutePath());
                } else {
                    log.warning("file does not exist at this path, and prepending /Volumes does not exist either: " + result.getAbsolutePath());
                }
            }
        }
        return result;
    }

    public static String fmPathForFile(File file) {
        String canonicalPath = PluginUtils.canonicalPathForFile(file);
        if (canonicalPath == null || canonicalPath.length() == 0) {
            return null;
        }
        if (PluginUtils.isMac()) {
            String firstPathComponent;
            File fileInVolumes;
            String volumePrefix = "/Volumes";
            if (canonicalPath.startsWith(volumePrefix + "/")) {
                return canonicalPath.substring(volumePrefix.length());
            }
            int secondSlash = canonicalPath.indexOf(47, 1);
            if (secondSlash != -1 && (fileInVolumes = new File(volumePrefix, firstPathComponent = canonicalPath.substring(0, secondSlash))).exists()) {
                return PluginUtils.fmPathForFile(new File(volumePrefix, canonicalPath));
            }
            String prefix = PluginUtils.getBootVolumeName();
            if (prefix.length() > 0) {
                prefix = "/" + prefix;
            }
            return prefix + canonicalPath;
        }
        return canonicalPath;
    }

    private static String canonicalPathForFile(File file) {
        String canonicalPath;
        if (file == null) {
            return null;
        }
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Unable to get canonical path for " + file + ", using absolute path instead");
            canonicalPath = file.getAbsolutePath();
        }
        return canonicalPath;
    }

    public static String getBootVolumeName() {
        if (bootVolumeName == null) {
            bootVolumeName = "";
            String[] commands = new String[]{"/usr/bin/osascript", "-s", "o", "-e", "tell application \"Finder\" to name of the startup disk"};
            try {
                Process process = Runtime.getRuntime().exec(commands);
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    bootVolumeName = bufferedReader.readLine();
                    bufferedReader.close();
                    log.log(Level.INFO, "Boot volume name is '" + bootVolumeName + "'");
                    if ("-1".equals(bootVolumeName)) {
                        log.log(Level.WARNING, "Invalid boot volume name " + bootVolumeName + ", returning empty string");
                        bootVolumeName = "";
                    }
                } else {
                    log.log(Level.WARNING, "Boot volume script exited with code " + exitCode + ", returning empty string");
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Couldn't get name of boot volume, returning empty string", e);
            }
        }
        return bootVolumeName;
    }

    public static InputStreamInfo getInputStreamInfo(FMData data, @Nullable PluginContext context) throws IOException {
        InputStreamInfo result;
        FMBinaryInterface binary = data.getFMBinary(context);
        if (binary != null && binary.getStreamTypes(context) == null) {
            throw new IOException("This container object is not fully initialized.  This can happen if you nest plugin functions.  You should store container fields in an actual FileMaker field or variable before passing them to other function.");
        }
        if (binary != null && !binary.getStreamTypes(context).isEmpty()) {
            PluginUtils.checkRead(binary);
            result = binary.getInputStreamInfo(context);
        } else {
            String resourceLocation = data.getStringDataWithConvertedNewlines(context);
            PluginUtils.checkRead(resourceLocation);
            result = PluginUtils.getInputStreamInfoForString(resourceLocation);
        }
        return result;
    }

    public static void checkRead(String resourceLocation) throws SecurityException {
        if (Boolean.getBoolean("com.prosc.fmkit.preventLocalFileAccess")) {
            boolean isUrl;
            boolean bl = isUrl = resourceLocation.startsWith("http://") || resourceLocation.startsWith("https://");
            if (!isUrl) {
                throw new SecurityException("Local file access is not available due to security restrictions on this server.");
            }
        }
    }

    private static void checkRead(FMBinaryInterface binary) {
        boolean isStored;
        PluginUtils.loadFmkitProperties();
        if (Boolean.getBoolean("com.prosc.fmkit.preventLocalFileAccess") && !(isStored = binary instanceof FMBinary)) {
            throw new SecurityException("Local file access is not available due to security restrictions on this server.");
        }
    }

    public static void checkWrite(File writeTo) {
        PluginUtils.loadFmkitProperties();
        if (Boolean.getBoolean("com.prosc.fmkit.preventLocalFileAccess")) {
            boolean isLocal;
            boolean bl = isLocal = writeTo.getAbsolutePath().startsWith(System.getProperty("java.io.tmpdir")) || writeTo.getAbsolutePath().startsWith("/tmp/");
            if (!isLocal) {
                throw new SecurityException("Local file access is not available due to security restrictions on this server.");
            }
        }
    }

    public static InputStreamInfo getInputStreamInfoForString(String resourceLocation) throws IOException {
        if (resourceLocation == null || resourceLocation.length() == 0) {
            return null;
        }
        InputStreamInfo result = null;
        if (resourceLocation.startsWith("filemac:")) {
            resourceLocation = "/Volumes" + resourceLocation.substring("filemac:".length());
        } else if (resourceLocation.startsWith("filewin:")) {
            resourceLocation = resourceLocation.substring("filewin:".length());
        }
        int newlineIndex = resourceLocation.indexOf("\n");
        if (newlineIndex == -1) {
            newlineIndex = resourceLocation.indexOf("\r");
        }
        if (newlineIndex == -1 && resourceLocation.indexOf(":/") > 0 && (resourceLocation.startsWith("http") || resourceLocation.startsWith("file"))) {
            resourceLocation = resourceLocation.replaceAll(" ", "%20");
            resourceLocation = resourceLocation.replaceAll("SuperContainer/Files", "SuperContainer/RawData");
            URL url = new URL(resourceLocation);
            result = PluginUtils.getInputStreamInfoForUrl(url);
        } else if (newlineIndex == -1 && !resourceLocation.startsWith("<") && !resourceLocation.startsWith(" ")) {
            File file = PluginUtils.fileForFMPath(resourceLocation);
            try {
                result = new InputStreamInfo(file);
            }
            catch (FileNotFoundException e) {
                log.log(Level.FINE, "Not a real file: " + resourceLocation);
                throw new IOException("Attempt to locate file for path failed: " + resourceLocation, e);
            }
        }
        if (result == null) {
            byte[] buf = resourceLocation.getBytes("UTF-8");
            ByteArrayInputStream baos = new ByteArrayInputStream(buf);
            result = new InputStreamInfo(baos, "param.txt", buf.length, "text/plain");
        }
        return result;
    }

    public static InputStreamInfo getInputStreamInfoForUrl(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setUseCaches(false);
        String filename = PluginUtils.filenameForUrlContents(url, conn.getHeaderField("Content-Disposition"), conn.getContentType());
        InputStreamInfo result = new InputStreamInfo(conn.getInputStream(), filename, conn.getContentLength(), conn.getContentType());
        return result;
    }

    public static String filenameForUrlContents(URL url, String contentDisposition, String contentType) {
        int lastSlash;
        int mark;
        String filename = null;
        if (contentDisposition != null && (mark = contentDisposition.toLowerCase().indexOf("filename=")) >= 0) {
            int mark2 = contentDisposition.indexOf(59, mark += "filename=".length());
            if (mark2 == -1) {
                mark2 = contentDisposition.length();
            }
            filename = contentDisposition.substring(mark, mark2);
            filename = filename.replaceAll("\"", "");
        }
        if (filename == null) {
            int index;
            filename = url.getPath();
            if (filename != null && (index = filename.lastIndexOf(47)) != -1) {
                filename = filename.substring(index + 1);
            }
            if (filename == null || filename.length() == 0) {
                filename = "index";
                log.log(Level.WARNING, "Unable to calculate filename for url '" + url + "', using '" + filename + "' as default value");
            }
        }
        if (filename.indexOf(46) == -1 && contentType != null && (lastSlash = contentType.lastIndexOf(47)) != -1) {
            int semicolonIndex = contentType.indexOf(59);
            if (semicolonIndex == -1) {
                semicolonIndex = contentType.length();
            }
            filename = filename + '.' + contentType.substring(lastSlash + 1, semicolonIndex);
        }
        return filename;
    }

    public static Date dateforFmString(String dateFrom, @Nullable TimeZone timeZone, PluginContext pluginContext) throws FmCalculationException, ParseException {
        DateFormat df;
        try {
            df = dateFrom.indexOf(32) != -1 && dateFrom.indexOf(47) != -1 ? PluginUtils.getDateTimeFormat(pluginContext) : (dateFrom.indexOf(58) != -1 ? PluginUtils.getTimeFormat(pluginContext) : PluginUtils.getDateFormat(pluginContext));
        }
        catch (ParseException e) {
            throw new ParseException(e.getMessage() + ": " + dateFrom, e.getErrorOffset());
        }
        if (timeZone != null) {
            df.setTimeZone(timeZone);
        }
        return df.parse(dateFrom);
    }

    public static DateFormat getDateFormat(PluginContext pluginContext) throws FmCalculationException, ParseException {
        if (dateFormat == null) {
            String fmDateString = pluginContext.evaluateExpression("Date ( 1 ; 13 ; 2018 )").getStringData(pluginContext);
            log.log(Level.INFO, "Testing parsing against fmDateString: " + fmDateString + ".  This should be equivalent to 1/13/2018");
            String format = "MM/dd/yyyy";
            String javaDateString = "1/13/2018";
            long targetNumber = new SimpleDateFormat(format, Locale.US).parse(javaDateString).getTime();
            Locale[] localesArray = DateFormat.getAvailableLocales();
            ArrayList<Locale> locales = new ArrayList<Locale>(localesArray.length + 1);
            locales.add(Locale.getDefault());
            locales.addAll(Arrays.asList(localesArray));
            int[] dateFormats = new int[]{0, 1, 2, 3};
            for (Locale locale : locales) {
                for (int dateFormatStyle : dateFormats) {
                    DateFormat candidate = DateFormat.getDateInstance(dateFormatStyle, locale);
                    try {
                        Date parse = candidate.parse(fmDateString);
                        if (parse.getTime() != targetNumber) continue;
                        dateFormat = candidate;
                        return dateFormat;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            log.severe("Could not determine date format to parse date.  Expected this string: " + fmDateString + " to be the same date as 1/13/2018");
            throw new ParseException("Could not determine date format", 1);
        }
        return dateFormat;
    }

    public static DateFormat getTimeFormat(PluginContext pluginContext) throws FmCalculationException, ParseException {
        if (timeFormat == null) {
            String fmDateString = pluginContext.evaluateExpression("Time ( 13 ; 23 ; 59 )").getStringData(pluginContext);
            String format = "hh:mm:ss a";
            String javaDateString = "1:23:59 PM";
            long targetNumber = new SimpleDateFormat(format, Locale.US).parse(javaDateString).getTime();
            Locale[] localesArray = DateFormat.getAvailableLocales();
            ArrayList<Locale> locales = new ArrayList<Locale>(localesArray.length + 1);
            locales.add(Locale.getDefault());
            locales.addAll(Arrays.asList(localesArray));
            int[] timeFormats = new int[]{0, 1, 2, 3};
            for (Locale locale : locales) {
                for (int dateFormatStyle : timeFormats) {
                    DateFormat candidate = DateFormat.getTimeInstance(dateFormatStyle, locale);
                    try {
                        Date parse = candidate.parse(fmDateString);
                        if (parse.getTime() != targetNumber) continue;
                        timeFormat = candidate;
                        return timeFormat;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            log.severe("Could not determine time format to parse time.  Expected this string: " + fmDateString + " to be the same time as 1:23:59 PM");
            throw new ParseException("Could not parse time", 1);
        }
        return timeFormat;
    }

    public static DateFormat getDateTimeFormat(PluginContext pluginContext) throws FmCalculationException, ParseException {
        if (dateTimeFormat == null) {
            String fmDateString = pluginContext.evaluateExpression("Timestamp ( Date ( 1 ; 13 ; 2018 ) ; Time ( 13 ; 23 ; 59 ) )").getStringData(pluginContext);
            String format = "MM/dd/yyyy hh:mm:ss a";
            String javaDateString = "01/13/2018 1:23:59 PM";
            long targetNumber = new SimpleDateFormat(format, Locale.US).parse(javaDateString).getTime();
            Locale[] localesArray = DateFormat.getAvailableLocales();
            ArrayList<Locale> locales = new ArrayList<Locale>(localesArray.length + 1);
            locales.add(Locale.getDefault());
            locales.addAll(Arrays.asList(localesArray));
            log.log(Level.INFO, "Date candidates size: " + locales.size());
            int[] dateFormats = new int[]{0, 1, 2, 3};
            Object candidateLocale = null;
            int candidateDateStyle = 2;
            for (Locale locale : locales) {
                for (int dateFormatStyle : dateFormats) {
                    for (int timeFormatStyle : dateFormats) {
                        DateFormat candidate = DateFormat.getDateTimeInstance(dateFormatStyle, timeFormatStyle, locale);
                        try {
                            log.log(Level.FINE, "Attempting to parse with format candidate: Date: " + dateFormatStyle + ", Time: " + timeFormatStyle + ", Locale: " + locale.toString() + ", Pattern: " + ((SimpleDateFormat)candidate).toPattern());
                        }
                        catch (ClassCastException e) {
                            log.log(Level.FINE, "Attempting to parse with format candidate: Date: " + dateFormatStyle + ", Time: " + timeFormatStyle + ", Locale: " + locale.toString());
                        }
                        try {
                            Date parse = candidate.parse(fmDateString);
                            log.log(Level.FINE, "parse.getTime() = " + parse.getTime());
                            log.log(Level.FINE, "targetNumber = " + targetNumber);
                            if (parse.getTime() != targetNumber) continue;
                            dateTimeFormat = candidate;
                            return dateTimeFormat;
                        }
                        catch (ParseException e) {
                            log.log(Level.FINE, "Parse failed: " + e.getMessage());
                        }
                    }
                }
            }
            ArrayList<String> fmFormats = new ArrayList<String>();
            fmFormats.add("MM/dd/yyyy HH:mm:ss");
            fmFormats.add("yyyy-MM-dd H:mm:ss a");
            fmFormats.add("yyyy-MM-dd h:mm:ss a");
            fmFormats.add("yyyy/MM/dd h:mm:ss a");
            for (String fmFormat : fmFormats) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(fmFormat, Locale.US);
                    try {
                        log.log(Level.FINE, "Attempting to parse with format candidate: Date: " + fmFormat + ", Pattern: " + sdf.toPattern());
                    }
                    catch (ClassCastException e) {
                        log.log(Level.FINE, "Attempting to parse with format candidate: " + fmFormat);
                    }
                    Date parse = sdf.parse(fmDateString);
                    log.log(Level.FINE, "parse.getTime() = " + parse.getTime());
                    log.log(Level.FINE, "targetNumber = " + targetNumber);
                    if (parse.getTime() != targetNumber) continue;
                    dateTimeFormat = sdf;
                    return dateTimeFormat;
                }
                catch (ParseException e) {
                    log.log(Level.FINE, "Parse failed: " + e.getMessage());
                }
            }
            log.log(Level.SEVERE, "Could not determine timestamp format to parse timestamp.  Expected this string: " + fmDateString + " to be the same time as " + javaDateString);
            throw new ParseException("Could not parse timestamp", 1);
        }
        log.log(Level.INFO, "Returning already created DateTimeFormat");
        return dateTimeFormat;
    }

    public static Date dateforFmString(String dateFrom) throws ParseException {
        TimeZone zone = null;
        return PluginUtils.dateforFmString(dateFrom, zone);
    }

    public static Date dateforFmString(String dateFrom, @Nullable TimeZone timeZone) throws ParseException {
        if (dateFrom == null || dateFrom.length() == 0) {
            return null;
        }
        if (dateFrom.indexOf(32) != -1 && dateFrom.indexOf(47) != -1) {
            try {
                DateFormat df = DateFormat.getDateTimeInstance(3, 2);
                if (timeZone != null) {
                    df.setTimeZone(timeZone);
                }
                return df.parse(dateFrom);
            }
            catch (ParseException e) {
                try {
                    DateFormat df = DateFormat.getDateTimeInstance(3, 3);
                    if (timeZone != null) {
                        df.setTimeZone(timeZone);
                    }
                    return df.parse(dateFrom);
                }
                catch (ParseException e1) {
                    SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss aaa");
                    if (timeZone != null) {
                        sdf.setTimeZone(timeZone);
                    }
                    return sdf.parse(dateFrom);
                }
            }
        }
        if (dateFrom.indexOf(58) != -1) {
            DateFormat df = DateFormat.getTimeInstance(2);
            if (timeZone != null) {
                df.setTimeZone(timeZone);
            }
            try {
                return df.parse(dateFrom);
            }
            catch (ParseException e) {
                return new SimpleDateFormat("H:mm:ss").parse(dateFrom);
            }
        }
        DateFormat df = DateFormat.getDateInstance(3);
        if (timeZone != null) {
            df.setTimeZone(timeZone);
        }
        return df.parse(dateFrom);
    }

    public static Properties convertKeyValuesToMap(String[] keyValues) {
        Map.Entry[] keys;
        if (keyValues == null) {
            return new Properties();
        }
        StringBuilder combinedString = new StringBuilder(keyValues.length * 40);
        for (int n = 0; n < keyValues.length; ++n) {
            if (n > 0) {
                combinedString.append("\n");
            }
            combinedString.append(keyValues[n]);
        }
        Properties result = null;
        try {
            result = new Properties();
            PluginUtils.loadUnicodeProperties(result, combinedString.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry eachEntry : keys = result.entrySet().toArray(new Map.Entry[result.size()])) {
            String eachValue = (String)eachEntry.getValue();
            Object oldKey = eachEntry.getKey();
            String lowercase = String.valueOf(oldKey).toLowerCase();
            if (lowercase.equals(oldKey)) continue;
            result.setProperty(lowercase, eachValue);
        }
        return result;
    }

    public static CaseInsensitiveMap<String> convertKeyValuesToCaseInsensitiveMap(String[] keyValues, boolean omitEmptyValues) {
        CaseInsensitiveMap<String> result = new CaseInsensitiveMap<String>();
        if (keyValues == null) {
            return result;
        }
        if (keyValues.length == 1 && keyValues[0] != null && keyValues[0].charAt(0) == '{') {
            JsonObject jsonObject = new Gson().fromJson(keyValues[0], JsonObject.class);
            if (jsonObject != null) {
                jsonObject.entrySet().forEach(e -> result.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString()));
            }
        } else {
            for (String eachLine : keyValues) {
                int length;
                boolean didFindSeparator = false;
                int n = length = eachLine == null ? 0 : eachLine.length();
                if (length == 0) continue;
                for (int i = 0; i < length; ++i) {
                    char c = eachLine.charAt(i);
                    if (keyValueSeparators.indexOf(c) == -1) continue;
                    String key = eachLine.substring(0, i).trim();
                    String value = eachLine.substring(i + 1).trim();
                    if (value.length() != 0 || !omitEmptyValues) {
                        result.put(key, value);
                    }
                    didFindSeparator = true;
                    break;
                }
                if (omitEmptyValues || didFindSeparator) continue;
                result.put(eachLine, "");
            }
        }
        return result;
    }

    public static void loadUnicodeProperties(Map p, String unicodeString) throws IOException {
        BufferedReader br = new BufferedReader(new StringReader(unicodeString));
        String eachLine = null;
        while ((eachLine = br.readLine()) != null) {
            int length = eachLine.length();
            if (length == 0) continue;
            for (int i = 0; i < length; ++i) {
                char c = eachLine.charAt(i);
                if (keyValueSeparators.indexOf(c) == -1) continue;
                p.put(eachLine.substring(0, i).trim(), eachLine.substring(i + 1).trim());
                i = length;
            }
        }
    }

    public static void clearZeroLengthStrings(Properties p) {
        Map.Entry[] entries;
        for (Map.Entry eachEntry : entries = p.entrySet().toArray(new Map.Entry[p.size()])) {
            if (((String)eachEntry.getValue()).length() != 0) continue;
            p.remove(eachEntry.getKey());
        }
    }

    public static boolean booleanForString(String s) {
        return PluginUtils.booleanForString(s, false);
    }

    public static boolean booleanForString(String s, boolean defaultValueForEmptyString) {
        if (s == null || s.length() == 0) {
            return defaultValueForEmptyString;
        }
        return "1".equals(s) || Boolean.valueOf(s) != false;
    }

    public static long longForString(String s, long defaultValueForEmptyString) {
        if (s == null || s.length() == 0) {
            return defaultValueForEmptyString;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, "Illegal number format for " + s + ", using default value " + defaultValueForEmptyString, e);
            return defaultValueForEmptyString;
        }
    }

    public static boolean isHeadless() {
        return PluginBridge2.isHeadless();
    }

    public static void loadFmkitProperties() {
        String loadedPropertiesKey = "com.prosc.fmkit.loadedProperties";
        if (Boolean.getBoolean("com.prosc.fmkit.loadedProperties")) {
            return;
        }
        System.setProperty("com.prosc.fmkit.loadedProperties", "true");
        FileInputStream fis = null;
        try {
            File file = new File("/Library/Preferences/com.prosc.fmkit.properties");
            if (file.exists() && file.canRead()) {
                log.log(Level.INFO, "Loading custom properties from /Library/Preferences/com.prosc.fmkit.properties");
                fis = new FileInputStream(file);
                System.getProperties().load(fis);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly(fis);
        }
    }

    public static String backwardsCompatibleProperty(Properties props, String[] optionalParameters, String key, int index) {
        String positional;
        String result = props.getProperty(key);
        if (result == null && optionalParameters != null && optionalParameters.length > index && (positional = optionalParameters[index]) != null && positional.indexOf(61) == -1) {
            log.log(Level.WARNING, "Legacy argument format for parameter '" + key + "' at position " + index + ", consider switching your FileMaker calculation to use the newer key=value parameter type syntax");
            result = positional;
        }
        return result;
    }

    public static Color decodeColor(String colorString, int alpha) throws FeedbackException {
        if (colorString == null) {
            return null;
        }
        if (alpha < 0 || alpha > 255) {
            throw new FeedbackException("Color alpha level must be between 0 and 255");
        }
        try {
            if (colorString.startsWith("#")) {
                Color parsed = Color.decode(colorString);
                return new Color(parsed.getRed(), parsed.getGreen(), parsed.getBlue(), alpha);
            }
            if (colorString.toLowerCase().startsWith("rgb")) {
                String[] parts = colorString.split("[^0-9]+");
                return new Color(Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]), alpha);
            }
            throw new IllegalArgumentException(colorString);
        }
        catch (Exception e) {
            throw new FeedbackException("Invalid color format '" + colorString + "', colors should be formatted as #AABBCC or RGB(255,0,125)", e);
        }
    }

    @Nullable
    public static Integer integerFor(String s) throws FeedbackException {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        try {
            return Integer.valueOf(s.trim());
        }
        catch (NumberFormatException e) {
            throw new FeedbackException("Was expecting an integer type, but received " + s);
        }
    }

    @Nullable
    public static Double doubleFor(String s) throws FeedbackException {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        try {
            return Double.valueOf(s.trim());
        }
        catch (NumberFormatException e) {
            throw new FeedbackException("Was expecting a numeric type, but received " + s);
        }
    }

    public static void validateParametersRequired(Map<String, String> map, String ... keys) throws FeedbackException {
        StringBuilder missing = new StringBuilder();
        boolean missingParams = false;
        for (String eachKey : keys) {
            if (!StringUtils.isEmpty(map.get(eachKey))) continue;
            missingParams = true;
            if (missing.length() != 0) {
                missing.append(", ");
            }
            missing.append(eachKey);
        }
        if (missingParams) {
            throw new FeedbackException("You must specify a value for " + missing);
        }
    }

    public static void assertMapEmpty(CaseInsensitiveMap<String> map) throws FeedbackException {
        if (!map.isEmpty()) {
            throw new FeedbackException("Unknown parameter(s): " + map.keySet());
        }
    }

    static {
        dateFormat = null;
        timeFormat = null;
        dateTimeFormat = null;
        String osName = System.getProperty("os.name");
        IS_MAC = osName.toLowerCase().contains("mac");
        IS_WIN = osName.toLowerCase().contains("win");
        IS_LIN = osName.toLowerCase().contains("linux");
        log.fine("osName: " + osName);
    }
}

