/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.fmkit;

import com.prosc.fmkit.BadApiVersionException;
import com.prosc.fmkit.CodeToChild;
import com.prosc.fmkit.CodeToParent;
import com.prosc.fmkit.JackInputStream;
import com.prosc.fmkit.JackOutputStream;
import com.prosc.fmkit.PipeMessageReader;
import com.prosc.fmkit.PipeMessageSource;
import com.prosc.fmkit.PluginBridge2;
import com.prosc.fmkit.QuadChar;
import com.prosc.infrastructure.Platform;
import com.prosc.misc.infrastructure.ThreadDumpUtil;
import com.prosc.thread.MyThreadFactory;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PipeChild {
    private static final Logger log = Logger.getLogger(PipeChild.class.getName());
    private static final short BAD_VERSION = -1;
    private static final float THIS_VERSION = 1.01f;
    static final JackInputStream in = new JackInputStream(System.in);
    private static final JackOutputStream out = new JackOutputStream(System.out);
    private final ReentrantLock inputLock = new ReentrantLock();
    private PluginBridge2 pluginBridge;
    private final ExecutorService pluginThread = Executors.newFixedThreadPool(1, new MyThreadFactory("PluginBridge worker"));
    private final Map<Long, Object> threadsWaitingForCallback = new HashMap<Long, Object>();
    private final Map<Long, MessageFromParent> activeCallbackResponses = new HashMap<Long, MessageFromParent>();
    private LifeCycle lifeCycle;

    @NotNull
    private static PrintStream getPrintStreamForLogging() {
        return new PrintStream(System.err){

            @Override
            public void write(@NotNull byte[] buf, int off, int len) {
                byte[] bufWithTerminator;
                boolean addCarriageReturn;
                if (buf == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (len == 0) {
                    return;
                }
                boolean bl = addCarriageReturn = buf[len - 1] != 10;
                if (addCarriageReturn) {
                    bufWithTerminator = new byte[len + 3];
                    System.arraycopy(buf, off, bufWithTerminator, 0, len);
                    bufWithTerminator[bufWithTerminator.length - 3] = 10;
                } else {
                    bufWithTerminator = new byte[len + 2];
                    System.arraycopy(buf, off, bufWithTerminator, 0, len);
                }
                bufWithTerminator[bufWithTerminator.length - 2] = 11;
                bufWithTerminator[bufWithTerminator.length - 1] = 12;
                super.write(bufWithTerminator, 0, bufWithTerminator.length);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/prosc/fmkit/PipeChild$2", "write"));
            }
        };
    }

    public static void main(String[] args) throws InterruptedException {
        Thread mainThread = new Thread("Message dispatch thread"){

            @Override
            public void run() {
                new PipeChild().run();
            }
        };
        mainThread.setUncaughtExceptionHandler((thread, e) -> log.log(Level.SEVERE, "An uncaught exception occurred in thread " + thread.getName(), e));
        mainThread.start();
    }

    private PipeChild() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        try {
            this.lifeCycle = LifeCycle.running;
            while (this.lifeCycle != LifeCycle.shutdown) {
                boolean expectMessage;
                if (this.lifeCycle == LifeCycle.running) {
                    expectMessage = true;
                } else {
                    Map<Long, Object> map = this.threadsWaitingForCallback;
                    synchronized (map) {
                        while (this.lifeCycle == LifeCycle.closing && this.threadsWaitingForCallback.isEmpty()) {
                            try {
                                this.threadsWaitingForCallback.wait();
                            }
                            catch (InterruptedException e) {
                                System.exit(0);
                            }
                        }
                        expectMessage = !this.threadsWaitingForCallback.isEmpty();
                    }
                }
                if (!expectMessage) continue;
                this.obtainInputLock();
                MessageFromParent messageFromParent = this.receiveCommand();
                long threadId = messageFromParent.threadId;
                if (messageFromParent.codeToChild == CodeToChild.shutdown) {
                    boolean unsafeCalls = in.readBoolean();
                    log.info("Shutting down plug-in " + messageFromParent.quadChar.toString() + " on thread " + Thread.currentThread().getName() + " for parent thread: " + threadId);
                    this.consumeSeparator();
                    this.releaseInputLock();
                    this.doShutdown(unsafeCalls, threadId);
                    continue;
                }
                if (messageFromParent.codeToChild == CodeToChild.sessionEnded) {
                    log.info("Shutting down session " + messageFromParent.sessionId + " on thread " + Thread.currentThread().getName() + " for parent thread: " + threadId);
                    this.consumeSeparator();
                    this.releaseInputLock();
                    this.pluginThread.submit(() -> this.pluginBridge.onSessionEnd(messageFromParent.sessionId, threadId));
                    continue;
                }
                if (messageFromParent.codeToChild == CodeToChild.fileShutdown) {
                    log.info("Shutting down file " + messageFromParent.fileId + " / session " + messageFromParent.sessionId + " on thread " + Thread.currentThread().getName() + " for parent thread: " + threadId);
                    this.consumeSeparator();
                    this.releaseInputLock();
                    this.pluginThread.submit(() -> this.pluginBridge.onFileClose(messageFromParent.sessionId, messageFromParent.fileId));
                    continue;
                }
                if (messageFromParent.codeToChild == CodeToChild.threadEnded) {
                    long thread_that_ended = in.readLong();
                    log.fine("Shutting down thread " + thread_that_ended + " on thread " + Thread.currentThread().getName() + " for parent thread: " + threadId);
                    this.consumeSeparator();
                    this.releaseInputLock();
                    this.pluginThread.submit(() -> this.pluginBridge.onThreadEnd(thread_that_ended));
                    continue;
                }
                if (messageFromParent.codeToChild == CodeToChild.callbackResult) {
                    log.fine("Handling callback for threadId " + threadId + " / session " + messageFromParent.sessionId + " on thread " + Thread.currentThread().getName());
                    this.handleCallback(messageFromParent);
                    continue;
                }
                this.handleMessage(messageFromParent);
            }
            this.pluginThread.shutdownNow();
        }
        catch (IOException e) {
            String message = "Could not read from stdin; process will exit";
            log.log(Level.SEVERE, message, e);
            throw new IllegalStateException(message);
        }
    }

    private void obtainInputLock() {
        this.inputLock.lock();
    }

    private void releaseInputLock() {
        this.inputLock.unlock();
    }

    private MessageFromParent receiveCommand() throws IOException {
        long parentThreadId;
        MessageFromParent result = new MessageFromParent();
        result.threadId = parentThreadId = in.readLong();
        log.fine("Parent thread id: " + parentThreadId);
        log.fine("Reading session id");
        result.sessionId = in.readLong();
        log.fine("Session id: " + result.sessionId);
        log.fine("Reading file id");
        result.fileId = in.readLong();
        log.fine("File id: " + result.fileId);
        log.fine("Reading code to child");
        short codeToChild = in.readShort();
        result.codeToChild = CodeToChild.values()[codeToChild];
        log.fine("Command: " + result.codeToChild.name());
        log.fine("Reading QuadChar");
        result.quadChar = new QuadChar(in.readUTF16String());
        log.fine("QuadChar: " + result.quadChar.toString());
        log.fine("Received message from PipeParent: " + result);
        return result;
    }

    private void doShutdown(boolean unsafeCalls, long parentThreadId) throws IOException {
        this.lifeCycle = LifeCycle.closing;
        this.pluginThread.submit(() -> {
            System.err.print(ThreadDumpUtil.dumpThreadStackTrace());
            log.info("End of PipeChild run loop");
            this.pluginBridge.fmxShutdown(unsafeCalls, parentThreadId);
            try {
                this.sendMessage(CodeToParent.finished, parentThreadId, out1 -> out1.writeInt(0), Level.FINEST);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Could not send finished message back to PipeParent", e);
            }
            this.lifeCycle = LifeCycle.shutdown;
            Map<Long, Object> map = this.threadsWaitingForCallback;
            synchronized (map) {
                this.threadsWaitingForCallback.notifyAll();
            }
            if (Platform.isWin()) {
                System.exit(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E callback(CodeToParent codeToParent, long parentThreadId, PipeMessageSource messageToParent, PipeMessageReader<E> receiver) {
        try {
            Object lockObject = new Object();
            Map<Long, Object> map = this.threadsWaitingForCallback;
            synchronized (map) {
                this.threadsWaitingForCallback.put(parentThreadId, lockObject);
                this.threadsWaitingForCallback.notifyAll();
            }
            Object object = lockObject;
            synchronized (object) {
                this.activeCallbackResponses.remove(parentThreadId);
                this.sendMessage(codeToParent, parentThreadId, messageToParent, Level.FINE);
                log.fine("Sent callback message to parent: " + (Object)((Object)codeToParent));
                while (!this.activeCallbackResponses.containsKey(parentThreadId)) {
                    try {
                        lockObject.wait();
                    }
                    catch (InterruptedException e) {
                        log.warning("Waiting for callback; ignoring interruption on thread " + Thread.currentThread().getName());
                    }
                }
                MessageFromParent messageFromParent = this.activeCallbackResponses.remove(parentThreadId);
                if (messageFromParent.codeToChild != CodeToChild.callbackResult) {
                    throw new IllegalStateException("Expected a callbackResult message from parent for message " + (Object)((Object)codeToParent) + ", but received " + messageFromParent + ". This error is fatal.");
                }
                E result = null;
                if (receiver != null) {
                    result = receiver.readMessage(in);
                }
                this.consumeSeparator();
                Map<Long, Object> map2 = this.threadsWaitingForCallback;
                synchronized (map2) {
                    this.threadsWaitingForCallback.remove(parentThreadId);
                    this.threadsWaitingForCallback.notifyAll();
                }
                lockObject.notifyAll();
                return result;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while reading/writing pipe to parent process. This is a fatal error.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCallback(MessageFromParent messageFromParent) {
        Object lockObject;
        Object object = lockObject = this.threadsWaitingForCallback.get(messageFromParent.threadId);
        synchronized (object) {
            this.activeCallbackResponses.put(messageFromParent.threadId, messageFromParent);
            lockObject.notifyAll();
            while (this.activeCallbackResponses.containsKey(messageFromParent.threadId)) {
                try {
                    lockObject.wait();
                }
                catch (InterruptedException e) {
                    log.warning("Handling callback; ignoring interruption on thread " + Thread.currentThread().getName());
                }
            }
            this.releaseInputLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(MessageFromParent message) throws IOException {
        CodeToChild codeToChild = message.codeToChild;
        long threadId = message.threadId;
        if (codeToChild == CodeToChild.doIdle) {
            short idleState = in.readByte();
            boolean unsafeCalls = in.readBoolean();
            this.consumeSeparator();
            this.releaseInputLock();
            this.pluginThread.submit(() -> {
                this.pluginBridge.fmxIdle(idleState, unsafeCalls, threadId, message.sessionId);
                try {
                    this.sendMessage(CodeToParent.finished, threadId, out1 -> out1.writeInt(0), Level.FINEST);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Could not send finished message after doIdle", e);
                }
            });
        } else if (codeToChild == CodeToChild.showErrorDialog) {
            String pluginName = in.readUTF16String();
            String lastErrorString = in.readUTF16String();
            int errorLevel = in.readInt();
            boolean isExpired = in.readBoolean();
            this.consumeSeparator();
            this.releaseInputLock();
            this.pluginThread.submit(() -> {
                this.pluginBridge.showErrorDialog(pluginName, lastErrorString, errorLevel, isExpired, message.sessionId, threadId);
                try {
                    this.sendMessage(CodeToParent.finished, threadId, out1 -> out1.writeInt(0), Level.FINEST);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Could not send finished message after showErrorDialog", e);
                }
            });
        } else if (codeToChild == CodeToChild.doFunction) {
            boolean isGui;
            boolean unsafeCalls;
            long resultHolderToken;
            long[] params;
            short functionId;
            log.fine("-> doFunction started on thread " + Thread.currentThread().getName() + " for parent thread: " + threadId);
            PipeChild pipeChild = this;
            synchronized (pipeChild) {
                functionId = in.readShort();
                log.fine("functionId: " + functionId);
                params = new long[in.readInt()];
                for (int n = 0; n < params.length; ++n) {
                    params[n] = in.readLong();
                }
                resultHolderToken = in.readLong();
                log.fine("resultHolderToken: " + resultHolderToken);
                unsafeCalls = in.readBoolean();
                log.fine("unsafeCalls: " + unsafeCalls);
                isGui = in.readBoolean();
                log.fine("isGui: " + isGui);
                this.consumeSeparator();
                this.releaseInputLock();
            }
            this.pluginThread.submit(() -> {
                log.fine("-> doFunction started function id: " + functionId + " on thread " + Thread.currentThread().getName() + " for parent thread: " + threadId);
                short resultCode = this.pluginBridge.doFunction(functionId, params, resultHolderToken, unsafeCalls, threadId, message.sessionId, message.fileId, isGui);
                log.fine("<- doFunction finished function id: " + functionId + " on thread " + Thread.currentThread().getName() + " for parent thread: " + threadId);
                try {
                    this.sendMessage(CodeToParent.finished, threadId, out1 -> out1.writeInt(resultCode), Level.FINEST);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Could not send finished message after doFunction", e);
                }
            });
        } else if (codeToChild != CodeToChild.guiToBack) {
            if (codeToChild == CodeToChild.configure) {
                log.info("Configure called on thread " + Thread.currentThread().getName());
                boolean unsafeCalls = in.readBoolean();
                this.consumeSeparator();
                this.releaseInputLock();
                this.pluginThread.submit(() -> {
                    this.pluginBridge.fmxDoAppPreferences(unsafeCalls, threadId);
                    try {
                        this.sendMessage(CodeToParent.finished, threadId, out1 -> out1.writeInt(0), Level.FINEST);
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Could not send finished message after doAppPreferences", e);
                    }
                });
            } else if (codeToChild == CodeToChild.init) {
                log.info("Init called on thread " + Thread.currentThread().getName());
                log.info("Reading api version");
                short apiVersion = in.readShort();
                log.info("API version: " + apiVersion);
                log.info("Reading version string");
                String versionString = in.readUTF16String();
                log.info("Version string: " + versionString);
                log.info("Reading instance id");
                long instanceId = in.readLong();
                log.info("Instance ID: " + instanceId);
                log.info("Reading unsafe calls");
                boolean unsafeCalls = in.readBoolean();
                log.info("Unsafe calls: " + unsafeCalls);
                log.info("Reading path info");
                String pathInfo = in.readUTF16String();
                log.info("Path info: " + pathInfo);
                String logPath = in.readUTF16String();
                log.info("Reading application type");
                short applicationType = in.readShort();
                log.info("Application type: " + applicationType);
                log.info("Reading process identifier");
                int pid = in.readInt();
                log.info("Process identifier: " + pid);
                this.consumeSeparator();
                this.releaseInputLock();
                log.info("Init called with sessionId " + message.sessionId);
                this.pluginThread.submit(() -> {
                    short resultCode;
                    try {
                        this.pluginBridge = new PluginBridge2(this, pathInfo, logPath, applicationType, apiVersion, versionString, instanceId, unsafeCalls, threadId);
                        resultCode = apiVersion;
                    }
                    catch (BadApiVersionException e) {
                        log.log(Level.SEVERE, "BadVersionException", e);
                        resultCode = -1;
                    }
                    catch (Throwable t) {
                        log.log(Level.SEVERE, "Unexpected error while creating PluginBridge", t);
                        resultCode = -1;
                    }
                    short finalResultCode = resultCode;
                    try {
                        this.sendMessage(CodeToParent.finished, threadId, out1 -> out1.writeInt(finalResultCode), Level.FINEST);
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Could not send finished message after fmxInit", e);
                    }
                });
            } else {
                throw new IllegalStateException("No child handler for code: " + (Object)((Object)codeToChild));
            }
        }
    }

    private void consumeSeparator() throws IOException {
        byte separator = in.readByte();
        if (separator != -1) {
            throw new IllegalStateException("Expected a -1 separator byte, but received " + separator + ". This probably indicates that the child did not consume the entire message.");
        }
    }

    private synchronized void sendMessage(CodeToParent codeToParent, long parentThreadId, @Nullable PipeMessageSource source, Level logLevel) throws IOException {
        log.fine("Writing parent thread ID " + parentThreadId);
        out.writeLong(parentThreadId);
        log.fine("Writing separator after the parent thread ID");
        out.writeByte(-1);
        log.log(logLevel, "Sending message to parent: " + (Object)((Object)codeToParent) + ", parent thread ID " + parentThreadId + " from thread " + Thread.currentThread().getName());
        out.writeShort((short)codeToParent.ordinal());
        if (source != null) {
            source.writeTo(out);
        }
        log.fine("Writing separator for " + codeToParent.name() + " command");
        out.writeByte(-1);
        out.flush();
    }

    static {
        System.err.print("IMALIVE");
        System.err.flush();
        try {
            out.writeUTF("IMALIVE");
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PrintStream printStream = PipeChild.getPrintStreamForLogging();
        System.setOut(printStream);
        System.setErr(printStream);
        StreamHandler handler = new StreamHandler(printStream, new SimpleFormatter()){

            @Override
            public synchronized void publish(LogRecord record) {
                super.publish(record);
                this.flush();
            }
        };
        LogManager.getLogManager().reset();
        Logger.getLogger("").addHandler(handler);
        log.info("Configured console logging for version 1.01");
    }

    class MessageFromParent {
        CodeToChild codeToChild;
        QuadChar quadChar;
        long sessionId;
        long fileId;
        long threadId;

        MessageFromParent() {
        }

        public String toString() {
            return "MessageFromParent{ threadId=" + this.threadId + ", codeToChild=" + (Object)((Object)this.codeToChild) + ", quadChar=" + this.quadChar + ", sessionId=" + this.sessionId + ", fileId=" + this.fileId + '}';
        }
    }

    private static enum LifeCycle {
        running,
        closing,
        shutdown;

    }
}

