/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CSVReader
implements Closeable {
    private BufferedReader br;
    private boolean hasNext = true;
    private char separator;
    private char quotechar;
    private int skipLines;
    private boolean linesSkiped;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final int DEFAULT_SKIP_LINES = 0;

    public CSVReader(Reader reader) {
        this(reader, ',');
    }

    public CSVReader(Reader reader, char separator) {
        this(reader, separator, '\"');
    }

    public CSVReader(Reader reader, char separator, char quotechar) {
        this(reader, separator, quotechar, 0);
    }

    public CSVReader(Reader reader, char separator, char quotechar, int line) {
        this.br = new BufferedReader(reader);
        this.separator = separator;
        this.quotechar = quotechar;
        this.skipLines = line;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> allElements = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] nextLineAsTokens = this.readNext();
            if (nextLineAsTokens == null) continue;
            allElements.add(nextLineAsTokens);
        }
        return allElements;
    }

    public List<List<String>> readAllAsLists() throws IOException {
        ArrayList<List<String>> allElements = new ArrayList<List<String>>();
        while (this.hasNext) {
            String[] nextLineAsTokens = this.readNext();
            if (nextLineAsTokens == null) continue;
            allElements.add(Arrays.asList(nextLineAsTokens));
        }
        return allElements;
    }

    public String[] readNext() throws IOException {
        String nextLine = this.getNextLine();
        return this.hasNext ? this.parseLine(nextLine) : null;
    }

    private String getNextLine() throws IOException {
        String nextLine;
        if (!this.linesSkiped) {
            for (int i = 0; i < this.skipLines; ++i) {
                this.br.readLine();
            }
            this.linesSkiped = true;
        }
        if ((nextLine = this.br.readLine()) == null) {
            this.hasNext = false;
        }
        return this.hasNext ? nextLine : null;
    }

    private String[] parseLine(String nextLine) throws IOException {
        if (nextLine == null) {
            return null;
        }
        ArrayList<String> tokensOnThisLine = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        boolean inQuotes = false;
        do {
            if (inQuotes) {
                sb.append("\n");
                nextLine = this.getNextLine();
                if (nextLine == null) break;
            }
            for (int i = 0; i < nextLine.length(); ++i) {
                char c = nextLine.charAt(i);
                if (c == this.quotechar) {
                    if (inQuotes && nextLine.length() > i + 1 && nextLine.charAt(i + 1) == this.quotechar) {
                        sb.append(nextLine.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    boolean bl = inQuotes = !inQuotes;
                    if (i <= 2 || nextLine.charAt(i - 1) == this.separator || nextLine.length() <= i + 1 || nextLine.charAt(i + 1) == this.separator) continue;
                    sb.append(c);
                    continue;
                }
                if (c == this.separator && !inQuotes) {
                    tokensOnThisLine.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
            }
        } while (inQuotes);
        tokensOnThisLine.add(sb.toString());
        return tokensOnThisLine.toArray(new String[0]);
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }

    public static char detectSeparator(String s) {
        if (s.contains("\t")) {
            return '\t';
        }
        return ',';
    }

    public Stream<String[]> stream() {
        Spliterator<String[]> spliterator = new Spliterator<String[]>(){

            @Override
            public boolean tryAdvance(Consumer<? super String[]> action) {
                try {
                    String[] next = CSVReader.this.readNext();
                    if (next != null) {
                        action.accept((String[])next);
                    }
                    return next != null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Spliterator<String[]> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 1024;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }
}

