<?php 
require_once("datamodel/databaseoperations.php");

class tinymce_menu {
	
	/**
	 * This function creates a Button inside the TinyMCE Editor.
	 * 
	 * @param string $title Tooltip of the button
	 * @param string $image Path to the image that should be displayed for the button
	 * @return string The java script code needed for the button.
	 */
	public static function button_start($title, $image) {
		return "
		tinymce.create('tinymce.plugins.insert', {
			createControl: function(n, cm) {
				switch (n) {
					case 'insert':
						var c = cm.createMenuButton('insert', {
							title : '".$title."',
							image : '".$image."',
							icons : false
						});
							
						c.onRenderMenu.add(function(c, m) {
							";
	}
	
	/**
	 * This function adds a submenu to an already existing button or submenu.
	 * 
	 * @param unknown_type $var The name of the javascript variable that holds the submenu
	 * @param unknown_type $title The displayed name of the submenu
	 * @param unknown_type $parent Leave empty to generate directly for the button or give an existing javascript variable that may contain another variable
	 * @return string The javascript code for the submenu
	 */
	public static function submenu($var, $title, $parent="m") {
		return $var." = ".$parent.".addMenu({title : '".$title."'});".$parent.".addSeparator();";
	}
	
	/**
	 * This function adds a menu item to an already existing menu or menubutton.
	 * @param unknown_type $title The displayed name ot the menu item
	 * @param unknown_type $action The action that should be executed if the menu item has been selected
	 * @param unknown_type $parent Leave empty if you want to create a menu item directly under the menu button. Otherwise give the javascript submenu variable where the menu item should be created.
	 * @return string The javascript code for the menu item
	 */
	public static function item($title, $action, $parent="m") {
		return $parent.".add({title : '".$title."', ".$action."});".$parent.".addSeparator();";
	}
	
	/**
	 * This function creates the end of a button menu for the TinyMCE Editor.
	 * 
	 * @return string The javascript code to end the button to be inserted to TinyMCE Editor.
	 */
	public static function button_end() {
		return "
							});
							// Return the new menu button instance
							return c;
					}
			
					return null;
				}
			});
					";
	}
}

?>