<?php
class Team
{
	/**
	 * This is the id of the Team (necessary for database saving)
	 */
	private $id;
	
	/**
	 * This is the name of the Team
	 */
	private $name;
	
	/**
	 * This is the constructor for the Team class.
	 * 
	 * @param integer $id the id of the team (necessary for database storage)
	 * @param string $name the name of the team
	 */
	public function __construct($id, $name) 
	{
		if (is_numeric($id) && is_string($name)) {
			$this->id = $id;
			$this->name = $name;
		} else {
			$this->id = 0;
			$this->name = 'default';
		}
	}
	
	/**
	 * Returns the id of the team
	 */
	public function getId()
	{
		return $this->id;
	}
	
	/**
	 * Returns the name of the team
	 */
	public function getName()
	{
		return $this->name;
	}
}
?>