<?php

class Saison
{
	private $id;
	private $name;
	private $begin;
	private $end;
	
	public function __construct($id, $name, $begin, $end)
	{
		if (is_numeric($id) && is_string($name) && ($begin instanceof DateTime) && ($end instanceof DateTime)) {
			$this->id = $id;
			$this->name = $name;
			$this->begin = $begin;
			$this->end = $end;
		} else {
			$this->id = 0;
			$this->name = "default";
			$this->begin = new DateTime();
			$this->end = new DateTime();
		}
	}
	
	public function getId()
	{
		return $this->id;
	}
	
	public function getName()
	{
		return $this->name;
	}
	
	public function getBegin()
	{
		return $this->begin;
	}
	
	public function getEnd()
	{
		return $this->end;
	}
}

?>